# KKH Ride - Shared Hosting Deployment Guide

## Quick Setup Steps

### 1. Upload Files
```
/home/username/
├── ridepool/              ← Upload entire Laravel project here
│   ├── app/
│   ├── bootstrap/
│   ├── config/
│   ├── database/
│   ├── resources/
│   ├── routes/
│   ├── storage/
│   ├── vendor/
│   └── ...
│
└── public_html/           ← Your web root
    ├── index.php          ← Copy from index-shared-hosting.php
    ├── .htaccess          ← Copy from public/.htaccess
    ├── css/               ← Copy from public/
    ├── js/                ← Copy from public/
    └── storage/           ← Symlink or copy
```

### 2. Edit index.php Path
In `public_html/index.php`, update the path:
```php
$laravelPath = __DIR__ . '/../ridepool';  // Adjust to your actual path
```

### 3. Configure .env
```env
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

# NO /public in URL!
```

### 4. Set Permissions
```bash
chmod -R 755 storage
chmod -R 755 bootstrap/cache
```

### 5. Storage Link (via SSH or create manually)
```bash
# Option 1: SSH
cd public_html
ln -s ../ridepool/storage/app/public storage

# Option 2: Create manually
# Copy contents of storage/app/public to public_html/storage
```

### 6. Clear Cache (via SSH or route)
```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## Troubleshooting

**500 Error?**
- Check `storage/logs/laravel.log`
- Ensure storage folder is writable

**CSS/JS not loading?**
- Make sure you copied public folder contents to public_html

**Database Error?**
- Update DB credentials in .env
- Run migrations: `php artisan migrate`

---
**Login:** admin@ridepool.com / password
