<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone', 20)->nullable()->after('email');
            $table->string('avatar')->nullable()->after('phone');
            $table->enum('user_type', ['passenger', 'driver', 'both'])->default('passenger')->after('avatar');
            $table->boolean('is_verified')->default(false)->after('user_type');
            $table->string('verification_document')->nullable()->after('is_verified');
            $table->decimal('rating', 3, 2)->default(0)->after('verification_document');
            $table->integer('total_rides')->default(0)->after('rating');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['phone', 'avatar', 'user_type', 'is_verified', 'verification_document', 'rating', 'total_rides']);
        });
    }
};
