<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rides', function (Blueprint $table) {
            $table->id();
            $table->foreignId('driver_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('vehicle_id')->constrained('vehicles')->onDelete('cascade');
            $table->foreignId('route_id')->constrained('routes')->onDelete('cascade');
            $table->dateTime('departure_datetime');
            $table->dateTime('arrival_datetime')->nullable();
            $table->integer('available_seats');
            $table->decimal('price_per_seat', 10, 2);
            $table->decimal('full_car_price', 10, 2)->nullable();
            $table->enum('ride_status', ['scheduled', 'ongoing', 'completed', 'cancelled'])->default('scheduled');
            $table->text('pickup_point')->nullable();
            $table->text('drop_point')->nullable();
            $table->json('amenities')->nullable(); // AC, music, wifi, etc
            $table->json('ride_preferences')->nullable(); // smoking, pets, music
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rides');
    }
};
