@extends('admin.layout')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('content')
    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon blue">👥</div>
            <div class="stat-value">{{ number_format($stats['total_users']) }}</div>
            <div class="stat-label">Total Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">🚗</div>
            <div class="stat-value">{{ number_format($stats['total_drivers']) }}</div>
            <div class="stat-label">Drivers</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon purple">🎫</div>
            <div class="stat-value">{{ number_format($stats['total_bookings']) }}</div>
            <div class="stat-label">Total Bookings</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon orange">🛣️</div>
            <div class="stat-value">{{ number_format($stats['total_rides']) }}</div>
            <div class="stat-label">Total Rides</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon blue">🚙</div>
            <div class="stat-value">{{ number_format($stats['total_vehicles']) }}</div>
            <div class="stat-label">Vehicles</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">✅</div>
            <div class="stat-value">{{ number_format($stats['verified_users']) }}</div>
            <div class="stat-label">Verified Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon orange">⏳</div>
            <div class="stat-value">{{ number_format($stats['pending_kyc']) }}</div>
            <div class="stat-label">Pending KYC</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">💰</div>
            <div class="stat-value">Rs {{ number_format($stats['revenue']) }}</div>
            <div class="stat-label">Total Revenue</div>
        </div>
    </div>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 24px;">
        <!-- Recent Users -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Recent Users</h3>
                <a href="{{ route('admin.users') }}" class="btn btn-primary btn-sm">View All</a>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Type</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($recent_users as $user)
                        <tr>
                            <td>
                                <div class="user-cell">
                                    <div class="user-avatar-sm">{{ substr($user->name, 0, 1) }}</div>
                                    <div>
                                        <div style="font-weight: 700;">{{ $user->name }}</div>
                                        <div style="font-size: 12px; color: #64748b;">{{ $user->email }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge badge-info">{{ ucfirst($user->user_type) }}</span>
                            </td>
                            <td>
                                @if($user->is_verified)
                                    <span class="badge badge-success">Verified</span>
                                @else
                                    <span class="badge badge-warning">Pending</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" style="text-align: center; color: #64748b;">No users yet</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Recent Bookings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Recent Bookings</h3>
                <a href="{{ route('admin.bookings') }}" class="btn btn-primary btn-sm">View All</a>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th>Route</th>
                        <th>Passenger</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($recent_bookings as $booking)
                        <tr>
                            <td>
                                <div style="font-weight: 700;">
                                    {{ $booking->ride->route->fromCity->name ?? 'N/A' }} → {{ $booking->ride->route->toCity->name ?? 'N/A' }}
                                </div>
                                <div style="font-size: 12px; color: #64748b;">{{ $booking->number_of_seats }} seat(s)</div>
                            </td>
                            <td>{{ $booking->passenger->name ?? 'N/A' }}</td>
                            <td>
                                <span class="badge badge-{{ $booking->booking_status == 'confirmed' ? 'success' : 'warning' }}">
                                    {{ ucfirst($booking->booking_status) }}
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" style="text-align: center; color: #64748b;">No bookings yet</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Recent Rides -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Recent Rides</h3>
            <a href="{{ route('admin.rides') }}" class="btn btn-primary btn-sm">View All</a>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Route</th>
                    <th>Driver</th>
                    <th>Date</th>
                    <th>Price</th>
                    <th>Seats</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse($recent_rides as $ride)
                    <tr>
                        <td>
                            <div style="font-weight: 700;">
                                {{ $ride->route->fromCity->name ?? 'N/A' }} → {{ $ride->route->toCity->name ?? 'N/A' }}
                            </div>
                        </td>
                        <td>{{ $ride->driver->name ?? 'N/A' }}</td>
                        <td>{{ $ride->departure_datetime ? $ride->departure_datetime->format('M d, Y H:i') : 'N/A' }}</td>
                        <td>Rs {{ number_format($ride->price_per_seat * 280) }}</td>
                        <td>{{ $ride->available_seats }}/{{ $ride->vehicle->seats ?? '?' }}</td>
                        <td>
                            <span class="badge badge-{{ $ride->ride_status == 'scheduled' ? 'success' : 'warning' }}">
                                {{ ucfirst($ride->ride_status) }}
                            </span>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" style="text-align: center; color: #64748b;">No rides yet</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection
