@extends('admin.layout')

@section('title', 'KYC Verification')
@section('page-title', 'KYC Verification')

@section('content')
    <!-- KYC Stats -->
    <div class="stats-grid" style="margin-bottom: 24px;">
        <div class="stat-card">
            <div class="stat-icon orange">⏳</div>
            <div class="stat-value">{{ $pending_count }}</div>
            <div class="stat-label">Pending Verification</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">✅</div>
            <div class="stat-value">{{ $verified_count }}</div>
            <div class="stat-label">Verified Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon red">❌</div>
            <div class="stat-value">{{ $rejected_count }}</div>
            <div class="stat-label">Rejected</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon blue">📄</div>
            <div class="stat-value">{{ $total_submitted }}</div>
            <div class="stat-label">Total Submitted</div>
        </div>
    </div>

    <!-- Pending KYC Requests -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">⏳ Pending KYC Requests</h3>
        </div>
        @if($pending_users->count() > 0)
            <div style="padding: 20px; display: grid; gap: 20px;">
                @foreach($pending_users as $user)
                    <div style="background: #fffbeb; border: 2px solid #fde68a; border-radius: 16px; padding: 20px;">
                        <div style="display: flex; justify-content: space-between; align-items: flex-start; flex-wrap: wrap; gap: 16px;">
                            <!-- User Info -->
                            <div style="display: flex; gap: 16px; align-items: center;">
                                <div style="width: 60px; height: 60px; background: #f59e0b; border-radius: 12px; display: flex; align-items: center; justify-content: center; color: white; font-weight: 800; font-size: 24px;">
                                    {{ substr($user->name, 0, 1) }}
                                </div>
                                <div>
                                    <div style="font-weight: 800; font-size: 18px; color: #1e3a5f;">{{ $user->name }}</div>
                                    <div style="color: #64748b; font-size: 13px;">{{ $user->email }}</div>
                                    <div style="color: #64748b; font-size: 13px;">{{ $user->phone ?? 'No phone' }}</div>
                                    <div style="margin-top: 8px;">
                                        <span class="badge badge-info">{{ ucfirst($user->user_type ?? 'passenger') }}</span>
                                        <span style="font-size: 12px; color: #94a3b8; margin-left: 8px;">Submitted: {{ $user->updated_at->diffForHumans() }}</span>
                                    </div>
                                </div>
                            </div>

                            <!-- KYC Details -->
                            <div style="background: white; border-radius: 12px; padding: 16px; min-width: 280px;">
                                <div style="font-weight: 700; color: #1e3a5f; margin-bottom: 12px;">📄 Submitted Documents</div>
                                
                                @if($user->cnic)
                                    <div style="display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #f1f5f9;">
                                        <span style="color: #64748b; font-size: 13px;">CNIC Number</span>
                                        <span style="font-weight: 700; font-size: 13px;">{{ $user->cnic }}</span>
                                    </div>
                                @endif
                                
                                @if($user->address)
                                    <div style="display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #f1f5f9;">
                                        <span style="color: #64748b; font-size: 13px;">Address</span>
                                        <span style="font-weight: 700; font-size: 13px;">{{ Str::limit($user->address, 30) }}</span>
                                    </div>
                                @endif

                                @if($user->verification_document)
                                    <div style="margin-top: 12px;">
                                        <a href="{{ asset('storage/' . $user->verification_document) }}" target="_blank" class="btn btn-sm" style="background: #e0f7fa; color: #0369a1; width: 100%; justify-content: center;">
                                            👁️ View Document
                                        </a>
                                    </div>
                                @endif
                            </div>

                            <!-- Actions -->
                            <div style="display: flex; flex-direction: column; gap: 8px;">
                                <form action="{{ route('admin.kyc.approve', $user->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-primary" style="width: 140px;">
                                        ✅ Approve
                                    </button>
                                </form>
                                <form action="{{ route('admin.kyc.reject', $user->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-danger" style="width: 140px;">
                                        ❌ Reject
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div style="padding: 60px; text-align: center; color: #64748b;">
                <div style="font-size: 48px; margin-bottom: 16px;">✅</div>
                <div style="font-size: 18px; font-weight: 700;">No Pending KYC Requests</div>
                <div style="font-size: 14px;">All submissions have been processed</div>
            </div>
        @endif
    </div>

    <!-- Recently Verified -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">✅ Recently Verified Users</h3>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>User</th>
                    <th>CNIC</th>
                    <th>Type</th>
                    <th>Verified On</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($verified_users as $user)
                    <tr>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm" style="background: #10b981; color: white;">{{ substr($user->name, 0, 1) }}</div>
                                <div>
                                    <div style="font-weight: 700;">{{ $user->name }}</div>
                                    <div style="font-size: 12px; color: #64748b;">{{ $user->email }}</div>
                                </div>
                            </div>
                        </td>
                        <td style="font-weight: 600;">{{ $user->cnic ?? 'N/A' }}</td>
                        <td>
                            <span class="badge badge-info">{{ ucfirst($user->user_type ?? 'passenger') }}</span>
                        </td>
                        <td style="font-size: 13px; color: #64748b;">{{ $user->updated_at->format('M d, Y') }}</td>
                        <td>
                            <form action="{{ route('admin.kyc.revoke', $user->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Revoke verification for this user?');">
                                @csrf
                                <button type="submit" class="btn btn-sm" style="background: #fee2e2; color: #991b1b;">Revoke</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" style="text-align: center; color: #64748b; padding: 40px;">No verified users yet</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection
