@extends('admin.layout')

@section('title', 'Rides')
@section('page-title', 'Rides Management')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Rides ({{ $rides->total() }})</h3>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Route</th>
                    <th>Driver</th>
                    <th>Vehicle</th>
                    <th>Date & Time</th>
                    <th>Price</th>
                    <th>Seats</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse($rides as $ride)
                    <tr>
                        <td>
                            <div style="font-weight: 700;">
                                {{ $ride->route->fromCity->name ?? 'N/A' }} → {{ $ride->route->toCity->name ?? 'N/A' }}
                            </div>
                            <div style="font-size: 12px; color: #64748b;">
                                Est. {{ $ride->route->estimated_duration ?? 0 }} min
                            </div>
                        </td>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm">{{ substr($ride->driver->name ?? 'D', 0, 1) }}</div>
                                <div>
                                    <div style="font-weight: 600;">{{ $ride->driver->name ?? 'N/A' }}</div>
                                    <div style="font-size: 12px; color: #64748b;">{{ $ride->driver->phone ?? '' }}</div>
                                </div>
                            </div>
                        </td>
                        <td>
                            @if($ride->vehicle)
                                <div style="font-weight: 600;">{{ $ride->vehicle->make }} {{ $ride->vehicle->model }}</div>
                                <div style="font-size: 12px; color: #64748b;">{{ $ride->vehicle->license_plate }}</div>
                            @else
                                N/A
                            @endif
                        </td>
                        <td>
                            @if($ride->departure_datetime)
                                <div style="font-weight: 600;">{{ $ride->departure_datetime->format('M d, Y') }}</div>
                                <div style="font-size: 12px; color: #64748b;">{{ $ride->departure_datetime->format('h:i A') }}</div>
                            @else
                                N/A
                            @endif
                        </td>
                        <td style="font-weight: 700; color: #10b981;">Rs {{ number_format($ride->price_per_seat * 280) }}</td>
                        <td>
                            <span class="badge badge-{{ $ride->available_seats > 0 ? 'success' : 'danger' }}">
                                {{ $ride->available_seats }}/{{ $ride->vehicle->seats ?? '?' }}
                            </span>
                        </td>
                        <td>
                            @if($ride->ride_status == 'scheduled')
                                <span class="badge badge-success">Scheduled</span>
                            @elseif($ride->ride_status == 'completed')
                                <span class="badge badge-info">Completed</span>
                            @else
                                <span class="badge badge-warning">{{ ucfirst($ride->ride_status) }}</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" style="text-align: center; color: #64748b; padding: 40px;">No rides found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        {{ $rides->links() }}
    </div>
@endsection
