@extends('admin.layout')

@section('title', 'Users')
@section('page-title', 'Users Management')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Users ({{ $users->total() }})</h3>
            <a href="{{ route('admin.users.create') }}" class="btn btn-primary btn-sm">➕ Add User</a>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>User</th>
                    <th>Phone</th>
                    <th>Type</th>
                    <th>KYC Status</th>
                    <th>Admin</th>
                    <th>Joined</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($users as $user)
                    <tr>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm" style="background: {{ $user->is_admin ? '#00aff5' : '#e2e8f0' }}; color: {{ $user->is_admin ? 'white' : '#64748b' }};">
                                    {{ substr($user->name, 0, 1) }}
                                </div>
                                <div>
                                    <div style="font-weight: 700;">{{ $user->name }}</div>
                                    <div style="font-size: 12px; color: #64748b;">{{ $user->email }}</div>
                                </div>
                            </div>
                        </td>
                        <td>{{ $user->phone ?? 'N/A' }}</td>
                        <td>
                            <span class="badge badge-info">{{ ucfirst($user->user_type ?? 'passenger') }}</span>
                        </td>
                        <td>
                            @if($user->is_verified)
                                <span class="badge badge-success">Verified</span>
                            @elseif($user->verification_document)
                                <span class="badge badge-warning">Pending</span>
                            @else
                                <span class="badge badge-danger">Not Submitted</span>
                            @endif
                        </td>
                        <td>
                            @if($user->is_admin)
                                <span class="badge badge-success">Yes</span>
                            @else
                                <span class="badge badge-danger">No</span>
                            @endif
                        </td>
                        <td style="font-size: 13px; color: #64748b;">{{ $user->created_at->format('M d, Y') }}</td>
                        <td>
                            <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                                <a href="{{ route('admin.users.edit', $user->id) }}" class="btn btn-sm" style="background: #e0f7fa; color: #0369a1;">Edit</a>
                                @if(!$user->is_verified && $user->verification_document)
                                    <form action="{{ route('admin.users.verify', $user->id) }}" method="POST" style="display: inline;">
                                        @csrf
                                        <button type="submit" class="btn btn-primary btn-sm">Verify</button>
                                    </form>
                                @endif
                                <form action="{{ route('admin.users.toggle-admin', $user->id) }}" method="POST" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm" style="background: #ede9fe; color: #7c3aed;">
                                        {{ $user->is_admin ? 'Remove Admin' : 'Make Admin' }}
                                    </button>
                                </form>
                                @if($user->id !== auth()->id())
                                    <form action="{{ route('admin.users.delete', $user->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this user?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                    </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" style="text-align: center; color: #64748b; padding: 40px;">No users found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        {{ $users->links() }}
    </div>
@endsection
