@extends('layouts.app')

@section('title', 'Chat with ' . $otherUser->name)

@section('styles')
    <style>
        .chat-header {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
            background: white;
            border-radius: 14px;
            margin-bottom: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.04);
        }

        .back-btn {
            width: 36px;
            height: 36px;
            border-radius: 10px;
            background: #f8fafc;
            display: flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            color: #64748b;
        }

        .chat-avatar {
            width: 44px;
            height: 44px;
            border-radius: 12px;
            background: linear-gradient(135deg, #00aff5, #10b981);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            font-weight: 800;
            color: white;
        }

        .chat-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 12px;
        }

        .chat-info {
            flex: 1;
        }

        .chat-name {
            font-size: 15px;
            font-weight: 700;
            color: #1e3a5f;
        }

        .chat-status {
            font-size: 11px;
            color: #10b981;
        }

        .ride-info {
            background: #f0f9ff;
            padding: 10px 12px;
            border-radius: 10px;
            margin-bottom: 12px;
            font-size: 11px;
            color: #0369a1;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .messages-container {
            background: white;
            border-radius: 14px;
            padding: 12px;
            margin-bottom: 12px;
            min-height: 300px;
            max-height: 400px;
            overflow-y: auto;
            box-shadow: 0 2px 10px rgba(0,0,0,0.04);
        }

        .message {
            display: flex;
            margin-bottom: 12px;
        }

        .message.sent {
            justify-content: flex-end;
        }

        .message.received {
            justify-content: flex-start;
        }

        .message-bubble {
            max-width: 75%;
            padding: 10px 14px;
            border-radius: 14px;
            font-size: 13px;
            line-height: 1.4;
        }

        .message.sent .message-bubble {
            background: linear-gradient(135deg, #00aff5, #10b981);
            color: white;
            border-bottom-right-radius: 4px;
        }

        .message.received .message-bubble {
            background: #f1f5f9;
            color: #1e3a5f;
            border-bottom-left-radius: 4px;
        }

        .message-time {
            font-size: 9px;
            margin-top: 4px;
            opacity: 0.7;
        }

        .message.sent .message-time {
            text-align: right;
        }

        .message-input-container {
            display: flex;
            gap: 10px;
            background: white;
            padding: 12px;
            border-radius: 14px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.04);
        }

        .message-input {
            flex: 1;
            padding: 12px 16px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 500;
            color: #1e3a5f;
            background: #f8fafc;
        }

        .message-input:focus {
            outline: none;
            border-color: #00aff5;
            background: white;
        }

        .send-btn {
            width: 48px;
            height: 48px;
            border: none;
            border-radius: 12px;
            background: linear-gradient(135deg, #00aff5, #10b981);
            color: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .send-btn:active {
            transform: scale(0.95);
        }

        .empty-chat {
            text-align: center;
            padding: 40px 20px;
            color: #94a3b8;
            font-size: 13px;
        }

        .date-divider {
            text-align: center;
            margin: 16px 0;
            font-size: 10px;
            color: #94a3b8;
            font-weight: 600;
        }
    </style>
@endsection

@section('content')
    <!-- Chat Header -->
    <div class="chat-header">
        <a href="{{ route('inbox') }}" class="back-btn">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <polyline points="15 18 9 12 15 6"></polyline>
            </svg>
        </a>
        <div class="chat-avatar">
            @if($otherUser->avatar ?? false)
                <img src="{{ asset('storage/' . $otherUser->avatar) }}" alt="{{ $otherUser->name }}">
            @else
                {{ substr($otherUser->name, 0, 1) }}
            @endif
        </div>
        <div class="chat-info">
            <div class="chat-name">{{ $otherUser->name }}</div>
            <div class="chat-status">● Online</div>
        </div>
    </div>

    @if($conversation->ride)
        <div class="ride-info">
            🚗 About ride: {{ $conversation->ride->route->fromCity->name ?? '' }} → {{ $conversation->ride->route->toCity->name ?? '' }}
        </div>
    @endif

    <!-- Messages -->
    <div class="messages-container" id="messagesContainer">
        @if($conversation->messages->count() > 0)
            @php $lastDate = null; @endphp
            @foreach($conversation->messages as $message)
                @php
                    $messageDate = $message->created_at->format('M d, Y');
                    $showDate = $messageDate !== $lastDate;
                    $lastDate = $messageDate;
                    $isSent = $message->sender_id == $user->id;
                @endphp

                @if($showDate)
                    <div class="date-divider">{{ $message->created_at->isToday() ? 'Today' : $messageDate }}</div>
                @endif

                <div class="message {{ $isSent ? 'sent' : 'received' }}">
                    <div class="message-bubble">
                        {{ $message->content }}
                        <div class="message-time">{{ $message->created_at->format('h:i A') }}</div>
                    </div>
                </div>
            @endforeach
        @else
            <div class="empty-chat">
                <p>👋 Say hello to {{ $otherUser->name }}!</p>
            </div>
        @endif
    </div>

    <!-- Message Input -->
    <form action="{{ route('inbox.send', $conversation->id) }}" method="POST" class="message-input-container">
        @csrf
        <input type="text" name="content" class="message-input" placeholder="Type a message..." required autofocus>
        <button type="submit" class="send-btn">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <line x1="22" y1="2" x2="11" y2="13"></line>
                <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
            </svg>
        </button>
    </form>

    <script>
        // Scroll to bottom of messages
        document.getElementById('messagesContainer').scrollTop = document.getElementById('messagesContainer').scrollHeight;
    </script>
@endsection
