<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>KKH Ride - Premium Carpooling across Pakistan</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Nastaliq+Urdu:wght@400;500;600;700&family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <style>
        :root {
            --primary: #00aff5;
            --primary-dark: #0099d9;
            --secondary: #002f34;
            --bg-light: #f6f7f9;
            --text-main: #002f34;
            --text-muted: #70808c;
            --white: #ffffff;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: var(--white);
            color: var(--text-main);
            overflow-x: hidden;
        }

        /* Header */
        .header {
            background: rgba(0, 47, 52, 0.85); /* Deep secondary color with transparency */
            backdrop-filter: blur(15px);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 85px;
            z-index: 5000;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            transition: all 0.5s cubic-bezier(0.165, 0.84, 0.44, 1);
        }

        .header.scrolled {
            transform: translateY(-100%);
        }

        .header-content {
            max-width: 1100px;
            margin: 0 auto;
            width: 100%;
            padding: 0 24px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
            color: #00aff5;
            font-size: 22px;
            font-weight: 700;
        }

        .logo svg {
            width: 38px;
            height: 38px;
        }

        .nav {
            display: flex;
            align-items: center;
            gap: 28px;
        }

        .nav-link {
            text-decoration: none;
            color: #ffffff;
            font-weight: 700;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px 18px;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.25);
            border-radius: 14px;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            text-shadow: 0 1px 4px rgba(0,0,0,0.1);
            perspective: 1000px;
        }

        .nav-link:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-3px) rotateX(10deg);
            border-color: rgba(255, 255, 255, 0.4);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
            color: #ffffff;
        }

        /* 2D Modern Flat Logo */
        .kkh-logo-2d {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            text-decoration: none;
            position: relative;
            padding: 10px 0;
            transition: transform 0.3s ease;
        }

        .kkh-logo-2d:hover {
            transform: translateY(-2px);
        }

        .logo-svg-container {
            position: absolute;
            top: -5px;
            left: -5px;
            width: 120%;
            height: 100%;
            pointer-events: none;
            z-index: 1;
        }

        .logo-svg-container svg {
            width: 100%;
            height: 100%;
            overflow: visible;
        }

        .arch-path {
            stroke: #00aff5;
            stroke-width: 3.5;
            stroke-linecap: round;
            fill: none;
            stroke-dasharray: 300;
            stroke-dashoffset: 300;
            animation: drawArch 1.2s ease-out infinite;
            animation-delay: 0s;
        }

        .logo-dot {
            fill: #ffffff;
            opacity: 0;
            animation: dotFadeIn 3s ease-out infinite;
        }

        .dot-1 { animation-delay: 0.7s; }
        .dot-2 { animation-delay: 0.9s; }
        .dot-3 { animation-delay: 1.1s; }

        @keyframes drawArch {
            0% { stroke-dashoffset: 300; }
            40% { stroke-dashoffset: 0; }
            100% { stroke-dashoffset: 0; }
        }

        @keyframes dotFadeIn {
            0% { opacity: 0; transform: scale(0.5); }
            30% { opacity: 1; transform: scale(1.2); }
            50% { opacity: 1; transform: scale(1); }
            100% { opacity: 1; transform: scale(1); }
        }

        .logo-text-2d {
            font-size: 32px;
            font-weight: 800;
            display: flex;
            align-items: center;
            line-height: 1;
            position: relative;
            z-index: 2;
            letter-spacing: -1.5px;
        }

        .kkh-2d {
            color: #00aff5;
            margin-right: 4px;
        }

        .ride-2d {
            color: #ffffff;
        }

        .logo-tagline-2d {
            font-size: 9px;
            font-weight: 700;
            color: rgba(255, 255, 255, 0.5);
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-top: 2px;
        }

        @keyframes speedLineMove {
            from { transform: translateX(0); opacity: 0; }
            50% { opacity: 1; }
            to { transform: translateX(-120px); opacity: 0; }
        }

        @keyframes textShimmer {
            to { background-position: 200% center; }
        }

        .nav-link svg {
            width: 18px;
            height: 18px;
            color: #ffffff;
        }

        .profile-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 14px;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.25);
            border-radius: 14px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
        }

        .profile-btn:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-2px);
        }

        .profile-avatar {
            width: 32px;
            height: 32px;
            background: #eee;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .btn {
            padding: 12px 24px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 700;
            font-size: 14px;
            transition: var(--transition);
            cursor: pointer;
            border: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0, 175, 245, 0.2);
        }

        .btn-outline {
            background: transparent;
            color: var(--primary);
            border: 2px solid var(--primary);
        }

        .btn-outline:hover {
            background: rgba(0, 175, 245, 0.05);
        }

        /* Animated Hero Text Section */
        .hero-text-section {
            background: #ffffff;
            padding: 120px 24px 60px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .hero-text-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 30% 50%, rgba(0, 175, 245, 0.08) 0%, transparent 50%),
                        radial-gradient(circle at 70% 50%, rgba(16, 185, 129, 0.05) 0%, transparent 50%);
            pointer-events: none;
        }

        .hero-text-content {
            max-width: 900px;
            margin: 0 auto;
            position: relative;
            z-index: 2;
        }

        .hero-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(0, 175, 245, 0.1);
            border: 1px solid rgba(0, 175, 245, 0.25);
            padding: 8px 20px;
            border-radius: 50px;
            margin-bottom: 24px;
            animation: fadeInUp 0.8s ease-out;
        }

        .hero-badge svg {
            width: 18px;
            height: 18px;
            color: #00aff5;
        }

        .hero-badge span {
            font-size: 13px;
            font-weight: 700;
            color: #00aff5;
        }

        .hero-main-title {
            font-size: 48px;
            font-weight: 800;
            color: #002f34;
            margin-bottom: 16px;
            line-height: 1.2;
            animation: fadeInUp 0.8s ease-out 0.1s backwards;
        }

        .hero-urdu-title {
            font-size: 38px;
            font-weight: 700;
            color: #00aff5;
            font-family: 'Noto Nastaliq Urdu', serif;
            direction: rtl;
            margin-bottom: 25px;
            line-height: 1.8;
            text-shadow: 0 2px 20px rgba(0, 175, 245, 0.3);
            animation: fadeInUp 0.8s ease-out 0.2s backwards, textGlow 3s ease-in-out infinite;
        }

        .hero-subtitle {
            font-size: 18px;
            color: #70808c;
            max-width: 600px;
            margin: 0 auto 30px;
            line-height: 1.6;
            animation: fadeInUp 0.8s ease-out 0.3s backwards;
        }

        .hero-features {
            display: flex;
            justify-content: center;
            gap: 40px;
            flex-wrap: wrap;
            animation: fadeInUp 0.8s ease-out 0.4s backwards;
        }

        .hero-feature {
            display: flex;
            align-items: center;
            gap: 10px;
            color: #002f34;
            font-size: 14px;
            font-weight: 600;
        }

        .hero-feature svg {
            width: 20px;
            height: 20px;
            color: #10b981;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes textGlow {
            0%, 100% {
                text-shadow: 0 4px 30px rgba(0, 175, 245, 0.4);
            }
            50% {
                text-shadow: 0 4px 50px rgba(0, 175, 245, 0.7), 0 0 80px rgba(0, 175, 245, 0.3);
            }
        }

        /* Floating particles */
        .hero-particles {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            overflow: hidden;
            pointer-events: none;
        }

        .hero-particle {
            position: absolute;
            width: 6px;
            height: 6px;
            background: rgba(0, 175, 245, 0.3);
            border-radius: 50%;
            animation: floatUp 10s infinite linear;
        }

        .hero-particle:nth-child(1) { left: 10%; animation-delay: 0s; }
        .hero-particle:nth-child(2) { left: 20%; animation-delay: 2s; }
        .hero-particle:nth-child(3) { left: 35%; animation-delay: 4s; }
        .hero-particle:nth-child(4) { left: 50%; animation-delay: 1s; }
        .hero-particle:nth-child(5) { left: 65%; animation-delay: 3s; }
        .hero-particle:nth-child(6) { left: 80%; animation-delay: 5s; }
        .hero-particle:nth-child(7) { left: 90%; animation-delay: 2.5s; }

        @keyframes floatUp {
            0% {
                transform: translateY(100vh) scale(0);
                opacity: 0;
            }
            10% {
                opacity: 1;
            }
            90% {
                opacity: 1;
            }
            100% {
                transform: translateY(-100px) scale(1.5);
                opacity: 0;
            }
        }

        @media (max-width: 768px) {
            .hero-text-section {
                padding: 100px 16px 40px;
            }
            .hero-main-title {
                font-size: 32px;
            }
            .hero-urdu-title {
                font-size: 28px;
            }
            .hero-subtitle {
                font-size: 15px;
            }
            .hero-features {
                gap: 20px;
            }
        }

        .hero {
            height: 420px;
            position: relative;
            padding-top: 0;
            overflow: hidden;
            width: 100%;
            background: linear-gradient(135deg, #0a1628 0%, #1a365d 30%, #0f2444 60%, #0a1628 100%);
        }

        /* 3D Animated Offer Banner */
        .hero-3d-banner {
            width: 100%;
            height: 100%;
            position: relative;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Animated background particles */
        .hero-particles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 1;
        }

        .particle {
            position: absolute;
            width: 6px;
            height: 6px;
            background: rgba(0, 175, 245, 0.6);
            border-radius: 50%;
            filter: blur(1px);
            animation: floatParticle 8s infinite linear;
        }

        .particle:nth-child(1) { left: 10%; animation-delay: 0s; animation-duration: 12s; }
        .particle:nth-child(2) { left: 20%; animation-delay: 2s; animation-duration: 10s; }
        .particle:nth-child(3) { left: 30%; animation-delay: 4s; animation-duration: 14s; }
        .particle:nth-child(4) { left: 40%; animation-delay: 1s; animation-duration: 11s; }
        .particle:nth-child(5) { left: 50%; animation-delay: 3s; animation-duration: 13s; }
        .particle:nth-child(6) { left: 60%; animation-delay: 5s; animation-duration: 9s; }
        .particle:nth-child(7) { left: 70%; animation-delay: 2s; animation-duration: 15s; }
        .particle:nth-child(8) { left: 80%; animation-delay: 0s; animation-duration: 10s; }
        .particle:nth-child(9) { left: 90%; animation-delay: 4s; animation-duration: 12s; }

        @keyframes floatParticle {
            0% { transform: translateY(420px) scale(0); opacity: 0; }
            10% { opacity: 1; }
            90% { opacity: 1; }
            100% { transform: translateY(-50px) scale(1.5); opacity: 0; }
        }

        /* Glowing orbs */
        .glow-orb {
            position: absolute;
            border-radius: 50%;
            filter: blur(80px);
            z-index: 1;
            animation: orbPulse 4s ease-in-out infinite;
        }

        .orb-1 {
            width: 300px;
            height: 300px;
            background: rgba(0, 175, 245, 0.3);
            top: -100px;
            left: -100px;
        }

        .orb-2 {
            width: 400px;
            height: 400px;
            background: rgba(16, 185, 129, 0.2);
            bottom: -150px;
            right: -100px;
            animation-delay: 2s;
        }

        .orb-3 {
            width: 200px;
            height: 200px;
            background: rgba(139, 92, 246, 0.25);
            top: 50%;
            left: 30%;
            animation-delay: 1s;
        }

        @keyframes orbPulse {
            0%, 100% { transform: scale(1); opacity: 0.6; }
            50% { transform: scale(1.2); opacity: 0.8; }
        }

        /* Hero content container */
        .hero-content-3d {
            position: relative;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 100%;
            max-width: 1200px;
            padding: 0 40px;
            height: 100%;
        }

        /* Offer text section */
        .offer-text-section {
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 20px;
            perspective: 1000px;
        }

        .offer-main-text {
            font-size: 52px;
            font-weight: 800;
            color: #ffffff;
            text-shadow: 0 4px 20px rgba(0, 175, 245, 0.5);
            line-height: 1.1;
            transform: rotateX(10deg);
            animation: textFloat 3s ease-in-out infinite;
        }

        .offer-urdu-text {
            font-size: 42px;
            font-weight: 700;
            color: #00aff5;
            text-shadow: 0 4px 30px rgba(0, 175, 245, 0.6);
            font-family: 'Noto Nastaliq Urdu', 'Jameel Noori Nastaleeq', serif;
            direction: rtl;
            animation: textFloat 3s ease-in-out infinite 0.5s;
        }

        .offer-sub-text {
            font-size: 22px;
            color: rgba(255, 255, 255, 0.85);
            font-weight: 500;
            max-width: 400px;
            line-height: 1.5;
        }

        .offer-badge {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            background: linear-gradient(135deg, rgba(0, 175, 245, 0.2) 0%, rgba(16, 185, 129, 0.2) 100%);
            border: 1px solid rgba(0, 175, 245, 0.4);
            padding: 12px 24px;
            border-radius: 50px;
            backdrop-filter: blur(10px);
            width: fit-content;
            animation: badgePulse 2s ease-in-out infinite;
        }

        .badge-icon {
            width: 24px;
            height: 24px;
            color: #10b981;
        }

        .badge-text {
            font-size: 16px;
            font-weight: 700;
            color: #ffffff;
        }

        @keyframes textFloat {
            0%, 100% { transform: translateY(0) rotateX(5deg); }
            50% { transform: translateY(-8px) rotateX(0deg); }
        }

        @keyframes badgePulse {
            0%, 100% { box-shadow: 0 0 20px rgba(0, 175, 245, 0.3); }
            50% { box-shadow: 0 0 40px rgba(0, 175, 245, 0.5); }
        }

        /* 3D Car section */
        .hero-car-section {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            perspective: 1000px;
        }

        .car-3d-container {
            position: relative;
            animation: carFloat 4s ease-in-out infinite;
            transform-style: preserve-3d;
        }

        .car-svg {
            width: 500px;
            height: auto;
            filter: drop-shadow(0 30px 60px rgba(0, 0, 0, 0.5));
        }

        .car-glow {
            position: absolute;
            bottom: -40px;
            left: 50%;
            transform: translateX(-50%);
            width: 400px;
            height: 80px;
            background: radial-gradient(ellipse, rgba(0, 175, 245, 0.4) 0%, transparent 70%);
            filter: blur(20px);
            animation: glowPulse 2s ease-in-out infinite;
        }

        .speed-lines {
            position: absolute;
            left: -100px;
            top: 50%;
            transform: translateY(-50%);
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .speed-line {
            width: 60px;
            height: 3px;
            background: linear-gradient(90deg, transparent, rgba(0, 175, 245, 0.8), transparent);
            border-radius: 10px;
            animation: speedLineAnim 1s infinite;
        }

        .speed-line:nth-child(1) { animation-delay: 0s; width: 80px; }
        .speed-line:nth-child(2) { animation-delay: 0.2s; width: 60px; }
        .speed-line:nth-child(3) { animation-delay: 0.4s; width: 100px; }
        .speed-line:nth-child(4) { animation-delay: 0.1s; width: 70px; }
        .speed-line:nth-child(5) { animation-delay: 0.3s; width: 50px; }

        @keyframes carFloat {
            0%, 100% { transform: translateY(0) rotateY(-5deg); }
            50% { transform: translateY(-15px) rotateY(5deg); }
        }

        @keyframes glowPulse {
            0%, 100% { opacity: 0.6; transform: translateX(-50%) scale(1); }
            50% { opacity: 1; transform: translateX(-50%) scale(1.1); }
        }

        @keyframes speedLineAnim {
            0% { transform: translateX(0); opacity: 0; }
            50% { opacity: 1; }
            100% { transform: translateX(-80px); opacity: 0; }
        }

        .search-area {
            position: relative;
            z-index: 100;
            margin-top: -40px; /* Overlap bottom of slider */
            padding-bottom: 20px;
        }

        .search-wrapper {
            width: 100%;
            max-width: 1100px;
            margin: 0 auto;
            padding: 0 24px;
        }

        /* Search Bar (Pill Shape) */
        .search-wrapper {
            width: 100%;
            max-width: 1000px;
            margin: 0 auto;
            z-index: 100;
        }

        .search-container {
            background: #ffffff;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid #ededed;
        }

        .search-container-inner {
            display: flex;
            align-items: center;
        }

        .search-form {
            display: flex;
            width: 100%;
            align-items: stretch;
        }

        .form-field {
            flex: 1;
            padding: 16px 20px;
            display: flex;
            flex-direction: column;
            gap: 4px;
            border-right: 1px solid #ededed;
            position: relative;
            cursor: pointer;
            transition: background 0.2s;
        }

        .form-field:last-child {
            border-right: none;
            padding-right: 8px;
        }

        .form-field:hover {
            background: #f5f5f5;
        }

        .form-field-icon {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            width: 20px;
            height: 20px;
            color: #70808c;
        }

        .form-field input, .form-field select {
            border: none;
            background: transparent;
            font-size: 16px;
            font-weight: 500;
            color: #054752;
            outline: none;
            width: 100%;
        }

        .form-field label {
            font-size: 12px;
            color: #70808c;
            font-weight: 500;
        }

        .search-btn {
            background: #00aff5;
            color: white;
            border: none;
            padding: 0 32px;
            font-size: 16px;
            font-weight: 700;
            border-top-right-radius: 16px;
            border-bottom-right-radius: 16px;
            cursor: pointer;
            transition: background 0.2s;
        }

        .search-btn:hover {
            background: #0099d9;
        }

        .hero p {
            color: var(--white);
            font-size: 20px;
            font-weight: 500;
            opacity: 0.95;
            margin-bottom: 40px;
            text-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        /* Search Form - Center in Hero & Sticky to Header */
        .search-wrapper {
            width: 100%;
            max-width: 1200px; /* Increased from 950px */
            margin: 40px auto 0;
            z-index: 1000;
            transition: all 0.5s cubic-bezier(0.165, 0.84, 0.44, 1);
        }

        .search-wrapper.sticky {
            position: fixed;
            top: 85px; /* Position below the header */
            left: 50%;
            transform: translateX(-50%);
            margin-top: 0;
            z-index: 1000; /* Below header (z-index: 5000) */
            max-width: 100%;
            width: 100%;
            padding: 12px 24px;
            background: white;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            animation: slideDown 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
        }

        .search-wrapper.sticky .search-container {
            max-width: 1200px;
            box-shadow: none;
            background: transparent;
            padding: 0;
        }

        .search-wrapper.sticky .search-container-inner {
            background: transparent;
            padding: 0;
        }

        @keyframes slideDown {
            from { transform: translate(-50%, -100%); opacity: 0; }
            to { transform: translate(-50%, 0); opacity: 1; }
        }

        .search-container {
            max-width: 100%; /* Use full width of wrapper */
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            padding: 2px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.12);
            position: relative;
            background: linear-gradient(90deg, 
                #00aff5 0%, 
                #10b981 20%, 
                #f59e0b 40%, 
                #ef4444 60%, 
                #8b5cf6 80%, 
                #00aff5 100%
            );
            background-size: 200% 100%;
            animation: aiBorder 4s linear infinite;
        }

        @keyframes aiBorder {
            0% { background-position: 0% 50%; }
            100% { background-position: 200% 50%; }
        }

        .search-container-inner {
            background: white;
            border-radius: 14px;
            padding: 6px;
            display: flex;
            align-items: stretch;
            gap: 6px;
        }

        .search-form {
            display: grid;
            grid-template-columns: 1fr 1fr 0.8fr 0.6fr 0.8fr auto auto; /* Added 0.6fr for Time */
            width: 100%;
            gap: 4px;
        }

        .form-field {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 8px 16px;
            background: #f8fafc;
            border-radius: 12px;
            transition: var(--transition);
            border: 1px solid transparent;
            cursor: pointer;
        }

        .voice-btn {
            background: #f8fafc;
            color: var(--primary);
            border: none;
            border-radius: 12px;
            padding: 0 14px;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .voice-btn:hover {
            background: #f1f5f9;
            color: #ef4444;
            transform: scale(1.05);
        }

        .voice-btn.listening {
            background: #fee2e2;
            color: #ef4444;
            animation: pulse-red 1.5s infinite;
        }

        @keyframes pulse-red {
            0% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.4); }
            70% { box-shadow: 0 0 0 15px rgba(239, 68, 68, 0); }
            100% { box-shadow: 0 0 0 0 rgba(239, 68, 68, 0); }
        }

        .voice-icon {
            width: 20px;
            height: 20px;
            transition: var(--transition);
        }

        .form-field:hover {
            background: #f1f5f9;
            border-color: rgba(0, 175, 245, 0.2);
            transform: translateY(-1px);
        }

        .form-field:hover .field-icon {
            transform: scale(1.2) rotate(5deg);
        }

        .field-icon {
            width: 20px;
            height: 20px;
            color: var(--primary);
            flex-shrink: 0;
            transition: var(--transition);
        }

        .field-input-group {
            display: flex;
            flex-direction: column;
            width: 100%;
        }

        /* Mobile Bottom Navigation - Professional App Style */
        .mobile-bottom-nav {
            display: none;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: #ffffff;
            height: 75px;
            z-index: 4000;
            border-top: none;
            padding: 0 4px;
            padding-bottom: env(safe-area-inset-bottom, 0);
            justify-content: space-around;
            align-items: center;
            box-shadow: 0 -8px 40px rgba(0, 0, 0, 0.1);
            border-radius: 28px 28px 0 0;
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 3px;
            text-decoration: none;
            color: #b0b8c1;
            font-size: 10px;
            font-weight: 600;
            width: 18%;
            padding: 8px 6px;
            border-radius: 16px;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            position: relative;
        }

        .nav-item span {
            transition: all 0.3s ease;
        }

        .nav-item.active {
            color: var(--primary);
        }

        .nav-item.active span {
            font-weight: 700;
        }

        .nav-item.active::before {
            content: '';
            position: absolute;
            top: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 32px;
            height: 3px;
            background: linear-gradient(90deg, #00aff5, #10b981);
            border-radius: 0 0 4px 4px;
            animation: indicatorPulse 2s ease-in-out infinite;
        }

        @keyframes indicatorPulse {
            0%, 100% { opacity: 1; width: 32px; }
            50% { opacity: 0.7; width: 40px; }
        }

        .nav-item:active {
            transform: scale(0.85);
        }

        .nav-item-icon {
            width: 24px;
            height: 24px;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }

        .nav-item.active .nav-item-icon {
            transform: scale(1.15) translateY(-2px);
            filter: drop-shadow(0 4px 8px rgba(0, 175, 245, 0.4));
            animation: iconBounce 0.6s ease-out;
        }

        @keyframes iconBounce {
            0% { transform: scale(0.8) translateY(0); }
            50% { transform: scale(1.25) translateY(-6px); }
            70% { transform: scale(1.1) translateY(-1px); }
            100% { transform: scale(1.15) translateY(-2px); }
        }

        /* Center FAB Button */
        .publish-btn-mobile {
            background: linear-gradient(135deg, #00aff5 0%, #10b981 100%);
            color: white;
            width: 58px;
            height: 58px;
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 8px 30px rgba(0, 175, 245, 0.45);
            margin-top: -36px;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            animation: fabPulse 3s ease-in-out infinite;
            position: relative;
        }

        @keyframes fabPulse {
            0%, 100% { 
                box-shadow: 0 8px 30px rgba(0, 175, 245, 0.45);
                transform: scale(1);
            }
            50% { 
                box-shadow: 0 12px 40px rgba(0, 175, 245, 0.6);
                transform: scale(1.02);
            }
        }

        .publish-btn-mobile::before {
            content: '';
            position: absolute;
            inset: -3px;
            border-radius: 23px;
            background: linear-gradient(135deg, rgba(0, 175, 245, 0.3), rgba(16, 185, 129, 0.3));
            z-index: -1;
            animation: fabGlow 2s ease-in-out infinite alternate;
        }

        @keyframes fabGlow {
            from { opacity: 0.5; transform: scale(1); }
            to { opacity: 1; transform: scale(1.05); }
        }

        .publish-btn-mobile:active {
            transform: scale(0.9) rotate(90deg);
            box-shadow: 0 4px 20px rgba(0, 175, 245, 0.6);
        }

        .publish-btn-mobile .nav-item-icon {
            color: white;
            width: 26px;
            height: 26px;
            transition: transform 0.4s ease;
        }

        .nav-item:nth-child(1) .nav-item-icon { animation-delay: 0s; }
        .nav-item:nth-child(2) .nav-item-icon { animation-delay: 0.1s; }
        .nav-item:nth-child(4) .nav-item-icon { animation-delay: 0.2s; }
        .nav-item:nth-child(5) .nav-item-icon { animation-delay: 0.3s; }

        @media (max-width: 968px) {
            .mobile-bottom-nav {
                display: flex;
            }

            /* Mobile App Header */
            .header {
                height: 56px;
                position: fixed;
                background: #ffffff;
                border: none;
                box-shadow: none;
                padding-top: env(safe-area-inset-top, 0);
            }

            .header-content {
                padding: 0 16px;
            }

            .header.scrolled {
                transform: none;
                background: #ffffff;
                position: fixed;
                border-bottom: none;
                box-shadow: 0 2px 20px rgba(0, 0, 0, 0.06);
            }

            .header .btn, .header .nav-link, .header .profile-btn {
                display: none;
            }

            /* Mobile Header - Center Logo */
            .header-content {
                justify-content: center;
            }

            /* Mobile App Logo - Same as Desktop with Colors */
            .kkh-logo-2d {
                padding: 6px 0;
            }

            .logo-text-2d {
                font-size: 26px;
            }

            .logo-tagline-2d {
                display: block;
                font-size: 8px;
                color: rgba(0, 47, 52, 0.5);
            }

            .logo-svg-container {
                display: block;
            }

            .arch-path {
                stroke: #00aff5;
            }

            .logo-dot {
                fill: #002f34;
            }

            .kkh-2d {
                color: #00aff5;
            }

            .ride-2d {
                color: #002f34;
            }

            /* Hero text section mobile */
            .hero-text-section {
                padding: 70px 16px 30px;
            }

            .hero-main-title {
                font-size: 20px;
                margin-bottom: 10px;
            }

            .hero-urdu-title {
                font-size: 18px;
                line-height: 1.5;
                margin-bottom: 12px;
            }

            .hero-subtitle {
                font-size: 12px;
                padding: 0 10px;
                margin-bottom: 16px;
            }

            .hero-features {
                gap: 12px;
                flex-wrap: wrap;
            }

            .hero-feature {
                font-size: 10px;
                gap: 5px;
            }

            .hero-feature svg {
                width: 14px;
                height: 14px;
            }

            .hero-badge {
                padding: 5px 12px;
                margin-bottom: 16px;
            }

            .hero-badge span {
                font-size: 10px;
            }

            /* Mobile Search Form - Compact */
            .search-area {
                display: block;
                margin-top: -20px;
                padding: 0 12px;
            }

            .search-wrapper {
                margin-top: 0 !important;
                padding: 0 !important;
            }

            .search-container {
                border-radius: 16px;
                padding: 2px;
            }

            .search-container-inner {
                padding: 12px;
                gap: 8px;
            }

            .search-form {
                grid-template-columns: 1fr 1fr;
                gap: 8px;
            }

            .form-field {
                padding: 10px 12px;
                border-radius: 10px;
            }

            .form-field label {
                font-size: 9px;
            }

            .form-field select,
            .form-field input {
                font-size: 12px;
            }

            .search-btn {
                grid-column: span 2;
                padding: 14px;
                font-size: 14px;
                font-weight: 700;
                border-radius: 12px;
                margin-top: 4px;
            }

            .hero {
                height: 500px;
                padding-top: 60px;
            }

            .hero-content-3d {
                flex-direction: column;
                padding: 20px;
                text-align: center;
                gap: 20px;
            }

            .offer-text-section {
                align-items: center;
                gap: 12px;
            }

            .offer-main-text {
                font-size: 28px;
            }

            .offer-urdu-text {
                font-size: 24px;
            }

            .offer-sub-text {
                font-size: 14px;
                text-align: center;
            }

            .offer-badge {
                padding: 8px 16px;
            }

            .badge-text {
                font-size: 12px;
            }

            .hero-car-section {
                display: none;
            }

            .car-svg {
                width: 280px;
            }

            .speed-lines {
                left: -50px;
            }

            .glow-orb.orb-1 {
                width: 150px;
                height: 150px;
            }

            .glow-orb.orb-2 {
                width: 200px;
                height: 200px;
            }

            .search-wrapper, .search-wrapper.sticky {
                position: relative;
                top: auto;
                left: auto;
                transform: none;
                margin-top: -30px;
                padding: 0 16px;
                width: 100%;
                max-width: 100%;
                z-index: 10;
                background: transparent;
                box-shadow: none;
                animation: none;
            }

            .header-mobile-right {
                display: flex !important;
            }

            .search-container {
                width: 100%;
                border-radius: 20px;
                margin: 0;
                padding: 3px;
                box-shadow: 0 8px 32px rgba(0, 0, 0, 0.12);
            }

            .search-container-inner {
                padding: 16px;
                border-radius: 18px;
                gap: 12px;
            }

            .search-form {
                grid-template-columns: 1fr 1fr;
                gap: 12px;
            }

            .form-field {
                padding: 14px 16px;
                border-radius: 14px;
                gap: 10px;
                min-width: 0;
                background: #f8fafc;
                border: 1px solid #e2e8f0;
                transition: all 0.3s ease;
            }

            .form-field:focus-within {
                border-color: var(--primary);
                background: #fff;
                box-shadow: 0 0 0 3px rgba(0, 175, 245, 0.1);
            }

            .field-icon {
                width: 18px;
                height: 18px;
                color: var(--primary);
            }

            .field-label {
                font-size: 10px;
                font-weight: 700;
                text-transform: uppercase;
                letter-spacing: 0.5px;
                color: var(--text-muted);
            }

            .field-input {
                font-size: 14px;
                font-weight: 600;
                padding: 2px 0;
                color: var(--text-main);
            }

            .voice-btn {
                height: 50px;
                grid-column: span 1;
                border-radius: 14px;
                background: #f8fafc;
                border: 1px solid #e2e8f0;
            }

            .btn-search {
                margin-top: 4px;
                height: 54px;
                grid-column: span 2;
                padding: 0 24px;
                font-size: 16px;
                font-weight: 700;
                border-radius: 14px;
                background: linear-gradient(135deg, #00aff5 0%, #0099d9 100%);
                color: white;
                border: none;
                box-shadow: 0 4px 15px rgba(0, 175, 245, 0.35);
                display: flex;
                align-items: center;
                justify-content: center;
                gap: 10px;
                transition: all 0.3s ease;
            }

            .btn-search:hover, .btn-search:active {
                background: linear-gradient(135deg, #0099d9 0%, #0088c2 100%);
                transform: translateY(-2px);
                box-shadow: 0 6px 20px rgba(0, 175, 245, 0.45);
            }

            .btn-search svg {
                width: 20px;
                height: 20px;
            }

            .stats {
                padding-bottom: 100px;
            }

            .rides-list {
                grid-template-columns: 1fr;
                gap: 16px;
                padding: 16px;
                padding-bottom: 120px;
            }

            .ride-card-enhanced {
                border-radius: 16px;
            }

            .ride-card-car-section {
                height: 140px;
            }

            .ride-card-details {
                padding: 12px;
                gap: 8px;
            }

            .ride-card-driver-row {
                gap: 10px;
            }

            .driver-avatar-lg {
                width: 40px;
                height: 40px;
                border-radius: 10px;
            }

            .driver-info-block .name {
                font-size: 13px;
            }

            .driver-info-block .vehicle-name {
                font-size: 10px;
            }

            .ride-card-route-row {
                gap: 8px;
            }

            .route-city {
                font-size: 13px;
            }

            .route-arrow {
                width: 14px;
                height: 14px;
            }

            .ride-card-meta-row {
                gap: 8px;
            }

            .ride-card-time {
                font-size: 11px;
            }

            .ride-card-time svg {
                width: 12px;
                height: 12px;
            }

            .ride-card-seats {
                font-size: 10px;
            }

            .ride-card-price-badge {
                padding: 6px 10px;
                font-size: 13px;
                border-radius: 10px;
                top: 10px;
                right: 10px;
            }

            .ride-card-ai-wrapper {
                border-radius: 16px;
            }

            .ride-card-enhanced {
                border-radius: 14px;
            }

            .available-header .container {
                padding-top: 16px !important;
                padding-bottom: 8px !important;
            }

            .section-title {
                font-size: 16px;
                margin-bottom: 0;
                font-weight: 700;
            }

            /* Smooth scrolling and overall mobile polish */
            html {
                scroll-behavior: smooth;
            }

            body {
                -webkit-overflow-scrolling: touch;
            }

            /* Container padding for mobile */
            .container {
                padding: 0 12px !important;
            }

            /* Footer mobile */
            .footer {
                padding: 50px 16px 100px;
            }

            .footer p {
                font-size: 12px;
            }

            /* Smooth animations */
            * {
                -webkit-tap-highlight-color: transparent;
            }

            /* Ride card wrapper animation timing */
            .ride-card-ai-wrapper {
                animation-duration: 0.4s;
            }
        }

        .field-label {
            font-size: 11px;
            font-weight: 700;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 2px;
        }

        .field-input {
            border: none;
            background: transparent;
            font-family: inherit;
            font-size: 16px;
            font-weight: 700;
            color: var(--text-main);
            outline: none;
            width: 100%;
            cursor: pointer;
            appearance: none;
            -webkit-appearance: none;
            padding: 4px 0;
            transition: var(--transition);
        }

        select.field-input {
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%2300aff5' stroke-width='3' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpath d='m3 5 3 3 3-3'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right center;
            padding-right: 25px;
        }

        .form-field:focus-within {
            background: white;
            border-color: var(--primary);
            box-shadow: 0 4px 12px rgba(0, 175, 245, 0.1);
        }

        .field-input:focus {
            color: var(--primary);
        }

        .btn-search {
            background: var(--primary);
            color: white;
            padding: 0 45px;
            border-radius: 14px;
            font-weight: 700;
            font-size: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            border: none;
            cursor: pointer;
            transition: var(--transition);
        }

        .search-icon-anim {
            transition: var(--transition);
        }

        .btn-search:hover .search-icon-anim {
            transform: translateX(3px);
        }

        .btn-search:hover {
            background: var(--primary-dark);
            box-shadow: 0 10px 20px rgba(0, 175, 245, 0.3);
        }

        /* Custom Dropdown Styling */
        .custom-dropdown {
            position: relative;
            width: 100%;
        }

        .dropdown-menu {
            position: absolute;
            top: calc(100% + 12px);
            left: 0;
            right: 0;
            background: white;
            border-radius: 16px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
            padding: 8px;
            z-index: 5000; /* Increased to stay above bottom nav */
            display: none;
            max-height: 280px;
            overflow-y: auto;
            border: 1px solid rgba(0, 175, 245, 0.1);
            animation: dropdownFade 0.2s ease-out;
        }

        .custom-dropdown.active .dropdown-menu {
            display: block;
        }

        @keyframes dropdownFade {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .dropdown-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px 14px;
            border-radius: 10px;
            cursor: pointer;
            transition: var(--transition);
            color: var(--text-main);
            font-weight: 600;
            font-size: 13px; /* Reduced for better mobile fit */
        }

        .dropdown-item:hover {
            background: rgba(0, 175, 245, 0.08);
            color: var(--primary);
        }

        .dropdown-item-icon {
            width: 18px;
            height: 18px;
            color: var(--primary);
            opacity: 0.7;
        }

        /* Hide native scrollbar but keep functionality */
        .dropdown-menu::-webkit-scrollbar {
            width: 6px;
        }
        .dropdown-menu::-webkit-scrollbar-thumb {
            background: #e2e8f0;
            border-radius: 10px;
        }

        /* Stats Section */
        .stats {
            padding: 80px 24px 60px;
            background: var(--white);
        }

        .section-title {
            font-size: 32px;
            font-weight: 800;
            color: var(--secondary);
            margin-bottom: 24px;
            text-align: center;
        }

        /* Rides Section */
        /* Ride Cards V2 Styling */
        .rides-list {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(360px, 1fr));
            gap: 24px;
            padding: 24px 0;
        }

        .ride-card-ai-wrapper {
            position: relative;
            padding: 2px;
            border-radius: 22px;
            background: linear-gradient(90deg, #00aff5, #10b981, #f59e0b, #ef4444, #8b5cf6, #00aff5);
            background-size: 200% 100%;
            animation: aiBorder 4s linear infinite;
            opacity: 0;
            transform: translateY(20px);
            animation: slideInUp 0.6s cubic-bezier(0.165, 0.84, 0.44, 1) forwards, aiBorder 4s linear infinite;
        }

        @keyframes slideInUp {
            to { opacity: 1; transform: translateY(0); }
        }

        .ride-card-v2 {
            display: flex;
            background: white;
            border-radius: 20px;
            padding: 18px;
            text-decoration: none;
            color: inherit;
            transition: var(--transition);
            min-height: 160px;
            position: relative;
            z-index: 1;
        }

        .ride-card-v2:hover {
            background: rgba(255, 255, 255, 0.95);
        }

        /* Enhanced Ride Card with Car Image */
        .ride-card-enhanced {
            display: flex;
            flex-direction: column;
            background: white;
            border-radius: 20px;
            overflow: hidden;
            text-decoration: none;
            color: inherit;
            transition: var(--transition);
            position: relative;
            z-index: 1;
        }

        .ride-card-enhanced:hover {
            transform: translateY(-4px);
        }

        .ride-card-car-section {
            height: 140px;
            background: linear-gradient(135deg, #1a365d 0%, #0a1628 100%);
            position: relative;
            overflow: hidden;
        }

        .ride-card-car-section img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }

        .ride-card-enhanced:hover .ride-card-car-section img {
            transform: scale(1.05);
        }

        .ride-card-car-placeholder {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #1a365d 0%, #0f2444 50%, #0a1628 100%);
        }

        .ride-card-car-placeholder svg {
            width: 80px;
            height: 80px;
            color: rgba(0, 175, 245, 0.4);
        }

        .ride-card-price-badge {
            position: absolute;
            top: 12px;
            right: 12px;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 8px 14px;
            border-radius: 12px;
            font-weight: 800;
            color: var(--primary);
            font-size: 16px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }

        .ride-card-details {
            padding: 18px;
            display: flex;
            flex-direction: column;
            gap: 14px;
        }

        .ride-card-driver-row {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .driver-avatar-lg {
            width: 50px;
            height: 50px;
            border-radius: 14px;
            background: var(--bg-light);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 800;
            color: var(--primary);
            position: relative;
            overflow: hidden;
            flex-shrink: 0;
            border: 2px solid #f0f9ff;
        }

        .driver-avatar-lg img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .verified-badge-lg {
            position: absolute;
            bottom: -3px;
            right: -3px;
            background: #10b981;
            color: white;
            font-size: 10px;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid white;
        }

        .driver-info-block {
            flex: 1;
            min-width: 0;
        }

        .driver-info-block .name {
            font-size: 15px;
            font-weight: 700;
            color: var(--text-main);
            margin-bottom: 2px;
        }

        .driver-info-block .vehicle-name {
            font-size: 12px;
            font-weight: 600;
            color: var(--text-muted);
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .ride-card-route-row {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px 14px;
            background: #f8fafc;
            border-radius: 12px;
        }

        .route-city {
            font-size: 14px;
            font-weight: 700;
            color: var(--text-main);
        }

        .route-arrow {
            color: var(--primary);
            flex-shrink: 0;
        }

        .ride-card-meta-row {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .ride-card-time {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 13px;
            font-weight: 600;
            color: var(--text-muted);
        }

        .ride-card-time svg {
            color: var(--primary);
        }

        .ride-card-seats {
            display: flex;
            align-items: center;
            gap: 6px;
            background: #f0fdf4;
            color: #10b981;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 700;
        }

        /* How to Book Section */
        .how-to-book-section {
            padding: 80px 24px;
            background: linear-gradient(180deg, #f8fafc 0%, #ffffff 100%);
            position: relative;
            overflow: hidden;
        }

        .how-to-book-title {
            text-align: center;
            font-size: 36px;
            font-weight: 800;
            color: var(--secondary);
            margin-bottom: 16px;
        }

        .how-to-book-subtitle {
            text-align: center;
            font-size: 18px;
            color: var(--text-muted);
            margin-bottom: 60px;
            font-weight: 500;
        }

        .booking-steps-container {
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 30px;
            position: relative;
        }

        /* Connecting Line */
        .booking-steps-container::before {
            content: '';
            position: absolute;
            top: 60px;
            left: 10%;
            right: 10%;
            height: 3px;
            background: linear-gradient(90deg, transparent 0%, var(--primary) 20%, var(--primary) 80%, transparent 100%);
            z-index: 0;
        }

        .booking-step-card {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(0, 175, 245, 0.1);
            border-radius: 24px;
            padding: 35px 25px;
            text-align: center;
            position: relative;
            z-index: 1;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            opacity: 0;
            transform: translateY(40px);
        }

        .booking-step-card.animate-in {
            opacity: 1;
            transform: translateY(0);
        }

        .booking-step-card:nth-child(1) { transition-delay: 0.1s; }
        .booking-step-card:nth-child(2) { transition-delay: 0.2s; }
        .booking-step-card:nth-child(3) { transition-delay: 0.3s; }
        .booking-step-card:nth-child(4) { transition-delay: 0.4s; }

        .booking-step-card:hover {
            transform: translateY(-12px) scale(1.02);
            box-shadow: 0 25px 50px rgba(0, 175, 245, 0.15);
            border-color: rgba(0, 175, 245, 0.3);
        }

        .step-number {
            position: absolute;
            top: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 34px;
            height: 34px;
            background: linear-gradient(135deg, var(--primary) 0%, #10b981 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 800;
            color: white;
            font-size: 14px;
            box-shadow: 0 6px 20px rgba(0, 175, 245, 0.4);
        }

        .step-icon {
            width: 80px;
            height: 80px;
            margin: 15px auto 25px;
            background: linear-gradient(135deg, rgba(0, 175, 245, 0.1) 0%, rgba(16, 185, 129, 0.1) 100%);
            border-radius: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 36px;
            transition: var(--transition);
        }

        .booking-step-card:hover .step-icon {
            transform: scale(1.1) rotate(5deg);
            background: linear-gradient(135deg, rgba(0, 175, 245, 0.2) 0%, rgba(16, 185, 129, 0.2) 100%);
        }

        .step-icon svg {
            width: 40px;
            height: 40px;
            color: var(--primary);
        }

        .step-title {
            font-size: 20px;
            font-weight: 800;
            color: var(--secondary);
            margin-bottom: 10px;
        }

        .step-description {
            font-size: 14px;
            color: var(--text-muted);
            line-height: 1.6;
            font-weight: 500;
        }

        @media (max-width: 968px) {
            .booking-steps-container {
                grid-template-columns: repeat(2, 1fr);
                gap: 16px;
            }
            
            .booking-steps-container::before {
                display: none;
            }

            .how-to-book-title {
                font-size: 22px;
                margin-bottom: 8px;
            }

            .how-to-book-subtitle {
                font-size: 13px;
                margin-bottom: 30px;
            }

            .how-to-book-section {
                padding: 40px 16px;
            }

            .booking-step-card {
                padding: 16px 12px;
                border-radius: 16px;
            }

            .step-number {
                width: 24px;
                height: 24px;
                font-size: 11px;
                top: -8px;
                right: -8px;
            }

            .step-icon {
                width: 50px;
                height: 50px;
                margin: 10px auto 15px;
                border-radius: 14px;
            }

            .step-icon svg {
                width: 26px;
                height: 26px;
            }

            .step-title {
                font-size: 14px;
                margin-bottom: 6px;
            }

            .step-description {
                font-size: 11px;
                line-height: 1.4;
            }
        }

        @media (max-width: 540px) {
            .booking-steps-container {
                grid-template-columns: repeat(2, 1fr);
                gap: 12px;
            }

            .booking-step-card {
                padding: 14px 10px;
            }

            .step-icon {
                width: 44px;
                height: 44px;
                margin: 8px auto 12px;
            }

            .step-icon svg {
                width: 22px;
                height: 22px;
            }

            .step-title {
                font-size: 13px;
            }

            .step-description {
                font-size: 10px;
            }
        }

        /* Modal Styling */
        .modal-backdrop {
            position: fixed;
            inset: 0;
            background: rgba(0, 47, 52, 0.4);
            backdrop-filter: blur(8px);
            z-index: 10000;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .modal-content {
            background: #f8fafc;
            width: 100%;
            max-width: 500px;
            height: 100%;
            max-height: 100vh;
            border-radius: 0;
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.2);
            overflow-y: auto;
            animation: modalSlideUp 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
            position: relative;
        }

        @keyframes modalSlideUp {
            from { transform: translateY(100%); }
            to { transform: translateY(0); }
        }

        /* Mobile Modal Enhancements */
        @media (max-width: 968px) {
            .modal-backdrop {
                padding: 0;
                align-items: flex-end;
            }

            .modal-content {
                max-width: 100%;
                max-height: 95vh;
                border-radius: 24px 24px 0 0;
                padding-bottom: 100px; /* Space for bottom nav */
            }

            .modal-body {
                padding: 20px 16px 120px 16px;
            }

            .modal-header {
                height: 200px;
            }

            .modal-close {
                top: 12px;
                left: 12px;
                width: 36px;
                height: 36px;
            }
        }

        .modal-header {
            position: relative;
            height: 240px;
            background: #eee;
        }

        .modal-header img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .modal-close {
            position: absolute;
            top: 20px;
            left: 20px;
            width: 40px;
            height: 40px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            z-index: 10;
        }

        .modal-body {
            padding: 24px;
            background: white;
            border-radius: 30px 30px 0 0;
            margin-top: -30px;
            position: relative;
            z-index: 5;
            min-height: 100%;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 24px;
            padding-bottom: 16px;
            border-bottom: 1px solid #f1f5f9;
        }

        .detail-item {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .detail-label {
            font-size: 11px;
            font-weight: 700;
            color: var(--text-muted);
            text-transform: uppercase;
        }

        .detail-val {
            font-size: 16px;
            font-weight: 700;
            color: var(--text-main);
        }

        .passenger-list {
            margin-top: 20px;
        }

        .passenger-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px;
            background: #f8fafc;
            border-radius: 12px;
            margin-bottom: 8px;
        }

        .passenger-avatar {
            width: 32px;
            height: 32px;
            background: var(--primary);
            color: white;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: 700;
        }

        .rating-stars {
            color: #f59e0b;
            display: flex;
            align-items: center;
            gap: 4px;
            font-size: 13px;
            font-weight: 700;
        }

        .card-left {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding-right: 20px;
        }

        .ride-time-v2 {
            display: flex;
            flex-direction: column;
            gap: 2px;
        }

        .ride-time-v2 .time {
            font-size: 20px;
            font-weight: 800;
            color: var(--text-main);
        }

        .ride-time-v2 .date {
            font-size: 13px;
            font-weight: 600;
            color: var(--text-muted);
        }

        .ride-route-v2 {
            margin-top: 15px;
            display: flex;
            flex-direction: column;
            gap: 4px;
            position: relative;
        }

        .ride-route-v2 .city {
            font-size: 15px;
            font-weight: 700;
            color: var(--text-main);
        }

        .route-line {
            width: 2px;
            height: 12px;
            background: var(--primary);
            margin: 2px 8px;
            border-radius: 2px;
            opacity: 0.5;
        }

        .card-divider {
            width: 1px;
            background: rgba(0, 0, 0, 0.06);
            margin: 0 5px;
        }

        .card-right {
            flex: 1.2;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding-left: 15px;
        }

        .driver-info {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
        }

        .driver-avatar {
            width: 44px;
            height: 44px;
            background: var(--bg-light);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 800;
            color: var(--primary);
            position: relative;
            overflow: visible;
        }

        .driver-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 12px;
        }

        .verified-badge {
            position: absolute;
            bottom: -5px;
            right: -5px;
            background: var(--primary);
            color: white;
            font-size: 8px;
            width: 14px;
            height: 14px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid white;
        }

        .driver-details {
            display: flex;
            flex-direction: column;
        }

        .driver-details .name {
            font-size: 14px;
            font-weight: 700;
            color: var(--text-main);
        }

        .driver-details .vehicle {
            font-size: 11px;
            font-weight: 600;
            color: var(--text-muted);
        }

        .ride-meta {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
        }

        .meta-item {
            display: flex;
            align-items: center;
            gap: 6px;
            color: var(--text-muted);
            font-size: 12px;
            font-weight: 600;
        }

        .price-box {
            display: flex;
            flex-direction: column;
            align-items: flex-end;
        }

        .price-val {
            font-size: 18px;
            font-weight: 800;
            color: var(--primary);
        }

        .price-label {
            font-size: 10px;
            font-weight: 700;
            color: var(--text-muted);
            text-transform: uppercase;
        }

        @media (max-width: 480px) {
            .rides-list {
                grid-template-columns: 1fr;
                padding: 16px;
            }
            .ride-card-v2 {
                flex-direction: column;
                gap: 15px;
            }
            .card-divider {
                width: 100%;
                height: 1px;
                margin: 0;
            }
            .card-left, .card-right {
                padding: 0;
            }
        }

        /* Footer */
        .footer {
            background: var(--secondary);
            color: white;
            padding: 80px 24px 40px;
        }

        .footer-content {
            max-width: 1200px;
            margin: 0 auto;
            text-align: center;
        }

        .footer p {
            opacity: 0.6;
            font-size: 14px;
        }

        /* Mobile Adjustments */
        @media (max-width: 968px) {
            .hero h1 { font-size: 42px; }
            .search-form { grid-template-columns: 1fr; }
            .stats-grid { grid-template-columns: 1fr; }
            .ride-card { flex-direction: column; align-items: flex-start; gap: 20px; }
        }

        /* Sticky Nav Enhancement */
        /* Offers Slider */
        .offers-section {
            padding: 40px 24px 20px;
            max-width: 1100px;
            margin: 0 auto;
        }

        .offers-container {
            width: 100%;
            height: auto;
            border-radius: 24px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        }

        .swiper-slide {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .offer-card {
            width: 100%;
            aspect-ratio: 21/9;
            background-size: cover;
            background-position: center;
            border-radius: 20px;
            position: relative;
            cursor: pointer;
            transition: transform 0.3s ease;
        }

        .offer-card:hover {
            transform: scale(0.99);
        }

        .swiper-pagination-bullet-active {
            background: var(--primary) !important;
        }

        @media (max-width: 768px) {
            .offer-card {
                aspect-ratio: 16/9;
            }
            .offers-section {
                padding: 24px 16px 10px;
            }
        }
    </style>
</head>
<body>
    <div class="mobile-bottom-nav">
        <a href="{{ route('home') }}" class="nav-item {{ request()->routeIs('home') ? 'active' : '' }}">
            <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                <polyline points="9 22 9 12 15 12 15 22"></polyline>
            </svg>
            <span>Home</span>
        </a>
        <a href="{{ route('rides.index') }}" class="nav-item {{ request()->routeIs('rides.*') ? 'active' : '' }}">
            <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <circle cx="11" cy="11" r="8"></circle>
                <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
            </svg>
            <span>Rides</span>
        </a>
        <a href="{{ route('rides.create') }}" class="nav-item">
            <div class="publish-btn-mobile">
                <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3">
                    <line x1="12" y1="5" x2="12" y2="19"></line>
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                </svg>
            </div>
            <span style="margin-top: 4px;">Offer</span>
        </a>
        <a href="{{ route('inbox') }}" class="nav-item {{ request()->routeIs('inbox') ? 'active' : '' }}">
            <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
            </svg>
            <span>Inbox</span>
        </a>
        <a href="{{ route('profile') }}" class="nav-item {{ request()->routeIs('profile') ? 'active' : '' }}">
            <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                <circle cx="12" cy="7" r="4"></circle>
            </svg>
            <span>Profile</span>
        </a>
    </div>

    <header class="header" id="header">
        <div class="header-content">
            <a href="{{ route('home') }}" class="kkh-logo-2d">
                <div class="logo-svg-container">
                    <svg viewBox="0 0 200 60">
                        <path d="M5,45 Q5,10 160,10" class="arch-path" />
                        <circle cx="172" cy="12" r="3" class="logo-dot dot-1" />
                        <circle cx="185" cy="22" r="3" class="logo-dot dot-2" />
                        <circle cx="192" cy="38" r="3" class="logo-dot dot-3" />
                    </svg>
                </div>
                <div class="logo-text-2d">
                    <span class="kkh-2d">kkh</span>
                    <span class="ride-2d">ride</span>
                </div>
                <span class="logo-tagline-2d">Premium Travels</span>
            </a>
            
            <nav class="nav">
                <a href="{{ route('rides.search') }}" class="nav-link">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>
                    Search
                </a>
                @auth
                    <a href="{{ route('rides.create') }}" class="nav-link">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>
                        Publish a ride
                    </a>
                    <a href="{{ route('profile') }}" class="nav-link" style="background: transparent; border-color: rgba(255,255,255,0.4);">
                        {{ auth()->user()->name }}
                    </a>
                @else
                    <a href="{{ route('login') }}" class="nav-link" style="background: transparent; border-color: rgba(255,255,255,0.4);">
                        Login
                    </a>
                    <a href="{{ route('register') }}" class="nav-link" style="background: #00aff5; border-color: #00aff5;">
                        Sign Up
                    </a>
                @endauth
            </nav>
        </div>
    </header>

    <!-- Animated Hero Text Section -->
    <section class="hero-text-section">
        <!-- Floating Particles -->
        <div class="hero-particles">
            <div class="hero-particle"></div>
            <div class="hero-particle"></div>
            <div class="hero-particle"></div>
            <div class="hero-particle"></div>
            <div class="hero-particle"></div>
            <div class="hero-particle"></div>
            <div class="hero-particle"></div>
        </div>

        <div class="hero-text-content">
            <div class="hero-badge">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M12 2L15.09 8.26L22 9.27L17 14.14L18.18 21.02L12 17.77L5.82 21.02L7 14.14L2 9.27L8.91 8.26L12 2Z"/>
                </svg>
                <span>Pakistan's #1 Ride Sharing Platform</span>
            </div>
            
            <h1 class="hero-main-title">Find Your Perfect Ride</h1>
            
            <h2 class="hero-urdu-title">سستی، محفوظ اور آرام دہ سواری</h2>
            
            <p class="hero-subtitle">
                گلگت سے کراچی تک، ہزاروں ڈرائیوروں کے ساتھ سفر کریں۔ پیسے بچائیں، ماحول بچائیں!
            </p>

            <div class="hero-features">
                <div class="hero-feature">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                        <polyline points="22 4 12 14.01 9 11.01"/>
                    </svg>
                    <span>Verified Drivers</span>
                </div>
                <div class="hero-feature">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <path d="M12 6v6l4 2"/>
                    </svg>
                    <span>24/7 Available</span>
                </div>
                <div class="hero-feature">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 1v22M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                    </svg>
                    <span>Best Prices</span>
                </div>
                <div class="hero-feature">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/>
                    </svg>
                    <span>Safe & Secure</span>
                </div>
            </div>
        </div>
    </section>


    <div class="search-area">
        <div class="search-wrapper" id="searchWrapper">
            <div class="search-container">
                <div class="search-container-inner">
                    <form action="{{ route('rides.search') }}" method="GET" class="search-form">
                        <div class="form-field">
                            <label>Leaving from</label>
                            <select name="from_city" required>
                                <option value="">Select City</option>
                                @foreach($cities as $city)
                                    <option value="{{ $city->id }}">{{ $city->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="form-field">
                            <label>Going to</label>
                            <select name="to_city" required>
                                <option value="">Select City</option>
                                @foreach($cities as $city)
                                    <option value="{{ $city->id }}">{{ $city->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="form-field">
                            <label>Date</label>
                            <input type="date" name="date" value="{{ date('Y-m-d') }}">
                        </div>
                        
                        <div class="form-field">
                            <label>Passengers</label>
                            <select name="seats">
                                <option value="1">1 passenger</option>
                                <option value="2">2 passengers</option>
                                <option value="3">3 passengers</option>
                                <option value="4">4 passengers</option>
                            </select>
                        </div>
                        
                        <button type="submit" class="search-btn">Search</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats section removed per user request -->
    <section class="available-header">
        <div class="container" style="padding-top: 40px;">
            <h2 class="section-title">Available Rides</h2>
        </div>
    </section>

    <section class="rides-section" style="padding-top: 10px;" x-data="{ selectedRide: null }">
        <div class="rides-list">
            @forelse($upcomingRides as $ride)
                <div class="ride-card-ai-wrapper" style="animation-delay: {{ $loop->index * 0.1 }}s">
                    <a href="#" class="ride-card-enhanced" @click.prevent="selectedRide = {{ $ride->toJson() }}; console.log(selectedRide)">
                        {{-- Car Image Section --}}
                        <div class="ride-card-car-section">
                            @if($ride->vehicle->vehicle_images && count($ride->vehicle->vehicle_images) > 0)
                                <img src="{{ asset('storage/' . $ride->vehicle->vehicle_images[0]) }}" alt="{{ $ride->vehicle->brand }} {{ $ride->vehicle->model }}">
                            @else
                                <div class="ride-card-car-placeholder">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                        <path d="M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                        <path d="M5 17h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5"></path>
                                    </svg>
                                </div>
                            @endif
                            <div class="ride-card-price-badge">
                                Rs {{ number_format($ride->price_per_seat * 280, 0) }}
                            </div>
                        </div>
                        
                        {{-- Details Section --}}
                        <div class="ride-card-details">
                            {{-- Driver Row --}}
                            <div class="ride-card-driver-row">
                                <div class="driver-avatar-lg">
                                    @if($ride->driver->avatar)
                                        <img src="{{ asset('storage/' . $ride->driver->avatar) }}" alt="{{ $ride->driver->name }}">
                                    @else
                                        {{ substr($ride->driver->name, 0, 1) }}
                                    @endif
                                    @if($ride->driver->is_verified)
                                        <div class="verified-badge-lg">✓</div>
                                    @endif
                                </div>
                                <div class="driver-info-block">
                                    <div class="name">{{ $ride->driver->name }}</div>
                                    <div class="vehicle-name">
                                        <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                            <path d="M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                                            <path d="M5 17h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5"></path>
                                        </svg>
                                        {{ $ride->vehicle->brand }} {{ $ride->vehicle->model }}
                                    </div>
                                    <div class="rating-stars" style="font-size: 11px;">
                                        ★ {{ number_format($ride->driver->rating ?? 4.5, 1) }}
                                    </div>
                                </div>
                            </div>

                            {{-- Route Row --}}
                            <div class="ride-card-route-row">
                                <span class="route-city">{{ $ride->route->fromCity->name }}</span>
                                <svg class="route-arrow" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M5 12h14"></path>
                                    <path d="M12 5l7 7-7 7"></path>
                                </svg>
                                <span class="route-city">{{ $ride->route->toCity->name }}</span>
                            </div>

                            {{-- Meta Row --}}
                            <div class="ride-card-meta-row">
                                <div class="ride-card-time">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                                        <circle cx="12" cy="12" r="10"></circle>
                                        <polyline points="12 6 12 12 16 14"></polyline>
                                    </svg>
                                    <span>{{ $ride->departure_datetime->format('H:i') }} • {{ $ride->departure_datetime->format('M d') }}</span>
                                </div>
                                <div class="ride-card-seats">
                                    <svg width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                    {{ $ride->available_seats }} seats
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            @empty
                <div style="text-align: center; grid-column: 1/-1; padding: 40px;">
                    <p style="color: var(--text-muted); font-weight: 500;">No rides available for this search.</p>
                </div>
            @endforelse
        </div>


        <!-- Ride Details Full Page Modal -->
        <template x-if="selectedRide">
            <div class="modal-backdrop" @click="selectedRide = null">
                <div class="modal-content" @click.stop>
                    <div class="modal-header">
                        <div class="modal-close" @click="selectedRide = null">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                        </div>
                        <img :src="selectedRide.vehicle.vehicle_images ? '/storage/' + selectedRide.vehicle.vehicle_images[0] : 'https://images.unsplash.com/photo-1544620347-c4fd4a3d5957?auto=format&fit=crop&q=80&w=1200'" alt="Vehicle">
                    </div>
                    
                    <div class="modal-body">
                        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 30px;">
                            <div style="display: flex; align-items: center; gap: 15px;">
                                <div class="driver-avatar" style="width: 56px; height: 56px; border-radius: 50%; border: 3px solid #f0fdf4;">
                                    <template x-if="selectedRide.driver.profile_photo_url">
                                        <img :src="selectedRide.driver.profile_photo_url" style="border-radius: 50%;">
                                    </template>
                                    <template x-if="!selectedRide.driver.profile_photo_url">
                                        <span x-text="selectedRide.driver.name.substring(0,1)" style="font-size: 22px;"></span>
                                    </template>
                                    <div class="verified-badge" style="width: 18px; height: 18px; font-size: 10px; bottom: 0; right: 0;">✓</div>
                                </div>
                                <div style="display: flex; flex-direction: column;">
                                    <h3 style="font-size: 18px; font-weight: 800; color: var(--secondary);" x-text="selectedRide.driver.name"></h3>
                                    <div class="rating-stars">
                                        ★ <span x-text="(selectedRide.driver.rating || 4.8).toFixed(1)"></span> <span style="color: var(--text-muted); font-size: 11px; margin-left: 5px; font-weight: 600;">(50+ Rides)</span>
                                    </div>
                                </div>
                            </div>
                            <div style="text-align: right;">
                                <div style="font-size: 24px; font-weight: 900; color: var(--primary);">Rs <span x-text="Math.round(selectedRide.price_per_seat * 280)"></span></div>
                                <div style="font-size: 10px; font-weight: 800; color: var(--text-muted); text-transform: uppercase;">Per Seat</div>
                            </div>
                        </div>

                        <div class="detail-row">
                            <div class="detail-item">
                                <span class="detail-label">Departure</span>
                                <span class="detail-val" x-text="selectedRide.route.from_city.name"></span>
                                <span style="font-size: 12px; color: var(--text-muted); font-weight: 600;" x-text="selectedRide.departure_datetime.substring(11,16)"></span>
                            </div>
                            <div style="display: flex; align-items: center; padding: 0 20px;">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="var(--primary)" stroke-width="2.5"><path d="M5 12h14"></path><path d="M12 5l7 7-7 7"></path></svg>
                            </div>
                            <div class="detail-item" style="text-align: right;">
                                <span class="detail-label">Destination</span>
                                <span class="detail-val" x-text="selectedRide.route.to_city.name"></span>
                                <span style="font-size: 12px; color: var(--text-muted); font-weight: 600;">Arriving Soon</span>
                            </div>
                        </div>

                        <div style="background: #f8fafc; border-radius: 20px; padding: 20px; margin-bottom: 30px; display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                            <div class="detail-item">
                                <span class="detail-label">Vehicle Capacity</span>
                                <span class="detail-val" style="font-size: 14px;"><span x-text="selectedRide.vehicle.total_seats"></span> Total Seats</span>
                            </div>
                            <div class="detail-item" style="text-align: right;">
                                <span class="detail-label">Current Status</span>
                                <span class="detail-val" style="font-size: 14px; color: var(--primary);"><span x-text="selectedRide.available_seats"></span> Seats Left</span>
                            </div>
                        </div>

                        <div class="passenger-list">
                            <h4 class="detail-label" style="margin-bottom: 20px; display: flex; align-items: center; gap: 8px;">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5"><path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M23 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                                Passengers on this trip
                            </h4>
                            <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(140px, 1fr)); gap: 12px;">
                                <template x-for="booking in selectedRide.bookings" :key="booking.id">
                                    <div style="background: white; border: 1px solid #edf2f7; border-radius: 16px; padding: 12px; display: flex; align-items: center; gap: 10px;">
                                        <div class="passenger-avatar" style="width: 36px; height: 36px; border-radius: 50%; flex-shrink: 0;">
                                            <template x-if="booking.passenger.profile_photo_url">
                                                <img :src="booking.passenger.profile_photo_url" style="width: 100%; height: 100%; border-radius: 50%; object-fit: cover;">
                                            </template>
                                            <template x-if="!booking.passenger.profile_photo_url">
                                                <span x-text="booking.passenger.name.substring(0,1)"></span>
                                            </template>
                                        </div>
                                        <div style="overflow: hidden;">
                                            <div style="font-size: 13px; font-weight: 700; color: var(--secondary); white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" x-text="booking.passenger.name"></div>
                                            <div style="font-size: 10px; color: var(--text-muted); font-weight: 600;" x-text="booking.number_of_seats + ' Seat'"></div>
                                        </div>
                                    </div>
                                </template>
                            </div>
                            <template x-if="!selectedRide.bookings || selectedRide.bookings.length === 0">
                                <div style="background: #fffbeb; border: 1px dashed #fcd34d; border-radius: 16px; padding: 20px; text-align: center;">
                                    <p style="font-size: 13px; color: #92400e; font-weight: 700;">No one has booked yet. Be the first passenger!</p>
                                </div>
                            </template>
                        </div>

                        <div style="padding-bottom: 30px; margin-top: 30px; border-bottom: 1px solid #f1f5f9;">
                            <a :href="'/bookings/create?ride=' + selectedRide.id" class="btn btn-primary" style="width: 100%; display: flex; align-items: center; justify-content: center; gap: 10px; padding: 20px; font-size: 16px; border-radius: 18px; box-shadow: 0 10px 25px rgba(0, 175, 245, 0.3);">
                                <span>Book Seat Now</span>
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3"><line x1="5" y1="12" x2="19" y2="12"></line><line x1="12" y1="5" x2="19" y2="12"></line><line x1="12" y1="19" x2="19" y2="12"></line></svg>
                            </a>
                        </div>

                        <!-- Driver Reviews Section -->
                        <div style="margin-top: 30px; padding-bottom: 40px;">
                            <h4 class="detail-label" style="margin-bottom: 20px; display: flex; align-items: center; gap: 8px;">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                                Recent Passenger Reviews
                            </h4>
                            <div style="display: flex; flex-direction: column; gap: 15px;">
                                <template x-if="selectedRide.driver.reviews_received && selectedRide.driver.reviews_received.length > 0">
                                    <template x-for="review in selectedRide.driver.reviews_received" :key="review.id">
                                        <div style="padding: 15px; border: 1px solid #edf2f7; border-radius: 20px;">
                                            <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 10px;">
                                                <div class="passenger-avatar" style="width: 32px; height: 32px; border-radius: 50%;">
                                                    <template x-if="review.reviewer.profile_photo_url">
                                                        <img :src="review.reviewer.profile_photo_url" style="width: 100%; height: 100%; border-radius: 50%; object-fit: cover;">
                                                    </template>
                                                    <template x-if="!review.reviewer.profile_photo_url">
                                                        <span x-text="review.reviewer.name.substring(0,1)" style="font-size: 12px;"></span>
                                                    </template>
                                                </div>
                                                <div style="flex: 1;">
                                                    <div style="font-size: 13px; font-weight: 700; color: var(--secondary);" x-text="review.reviewer.name"></div>
                                                    <div class="rating-stars" style="font-size: 10px;">
                                                        <template x-for="i in review.rating">
                                                            <span>★</span>
                                                        </template>
                                                    </div>
                                                </div>
                                            </div>
                                            <p style="font-size: 13px; color: var(--text-main); line-height: 1.5; font-weight: 500;" x-text="review.comment"></p>
                                        </div>
                                    </template>
                                </template>
                                <template x-if="!selectedRide.driver.reviews_received || selectedRide.driver.reviews_received.length === 0">
                                    <div style="text-align: center; padding: 20px; background: #f8fafc; border-radius: 20px; border: 1px dashed #cbd5e1;">
                                        <p style="font-size: 13px; color: var(--text-muted); font-weight: 600;">No reviews yet for this driver.</p>
                                    </div>
                                </template>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </template>
    </section>

    {{-- How to Book Section --}}
    <section class="how-to-book-section" id="howToBookSection">
        <h2 class="how-to-book-title">How to Book Your Ride</h2>
        <p class="how-to-book-subtitle">Book your perfect ride in just 4 simple steps</p>
        
        <div class="booking-steps-container">
            {{-- Step 1: Search --}}
            <div class="booking-step-card">
                <div class="step-number">1</div>
                <div class="step-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="11" cy="11" r="8"></circle>
                        <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                    </svg>
                </div>
                <h3 class="step-title">Search Ride</h3>
                <p class="step-description">Enter your departure city, destination, date and number of passengers</p>
            </div>

            {{-- Step 2: Choose --}}
            <div class="booking-step-card">
                <div class="step-number">2</div>
                <div class="step-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                        <path d="M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"></path>
                        <path d="M5 17h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5"></path>
                    </svg>
                </div>
                <h3 class="step-title">Choose Your Car</h3>
                <p class="step-description">Browse available rides, check driver ratings and select your preferred vehicle</p>
            </div>

            {{-- Step 3: Book --}}
            <div class="booking-step-card">
                <div class="step-number">3</div>
                <div class="step-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect>
                        <line x1="1" y1="10" x2="23" y2="10"></line>
                    </svg>
                </div>
                <h3 class="step-title">Book & Pay</h3>
                <p class="step-description">Confirm your booking and make secure payment to reserve your seat</p>
            </div>

            {{-- Step 4: Enjoy --}}
            <div class="booking-step-card">
                <div class="step-number">4</div>
                <div class="step-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M12 2L15.09 8.26L22 9.27L17 14.14L18.18 21.02L12 17.77L5.82 21.02L7 14.14L2 9.27L8.91 8.26L12 2Z"></path>
                    </svg>
                </div>
                <h3 class="step-title">Enjoy Your Trip</h3>
                <p class="step-description">Meet your driver at pickup location and enjoy a safe, comfortable journey!</p>
            </div>
        </div>
    </section>

    <footer class="footer">

        <div class="footer-content">
            <h2 style="margin-bottom: 24px;">KKH RIDE</h2>
            <p style="margin-bottom: 40px;">Changing the way Pakistan travels. Safe, affordable, and social.</p>
            <p>&copy; {{ date('Y') }} KKH Ride. All rights reserved.</p>
        </div>
    </footer>

    <script>
        const searchWrapper = document.getElementById('searchWrapper');
        let searchOriginalTop = searchWrapper.getBoundingClientRect().top + window.scrollY;

        // Recalculate if needed on resize
        window.addEventListener('resize', () => {
             searchOriginalTop = searchWrapper.getBoundingClientRect().top + window.scrollY;
        });

        window.addEventListener('scroll', () => {
            const header = document.getElementById('header');
            
            // Header hide effect - DISABLED (header now always visible)
            // if (window.scrollY > 100) {
            //     header.classList.add('scrolled');
            // } else {
            //     header.classList.remove('scrolled');
            // }

            // Search form sticky logic
            if (window.scrollY > searchOriginalTop - 50) {
                searchWrapper.classList.add('sticky');
            } else {
                searchWrapper.classList.remove('sticky');
            }
        });

        // Initialize Swiper
        document.addEventListener('DOMContentLoaded', function() {
            const swiper = new Swiper('.hero-slider', {
                loop: true,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
                effect: 'fade',
                fadeEffect: {
                    crossFade: true
                },
                speed: 1500,
            });
        });

        // Voice Search Functionality
        let recognition = null;
        let isListening = false;

        function toggleVoiceSearch() {
            if (isListening) {
                stopVoiceSearch();
            } else {
                startVoiceSearch();
            }
        }

        function startVoiceSearch() {
            const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
            
            if (!SpeechRecognition) {
                alert("Voice search is not supported in this browser. Please use Chrome or Edge.");
                return;
            }

            recognition = new SpeechRecognition();
            recognition.lang = 'en-US';
            recognition.interimResults = false;
            recognition.maxAlternatives = 1;

            recognition.onstart = () => {
                isListening = true;
                const voiceBtn = document.getElementById('voiceBtn');
                voiceBtn.classList.add('listening');
                console.log('Voice recognition started...');
            };

            recognition.onresult = (event) => {
                const transcript = event.results[0][0].transcript.toLowerCase();
                console.log('Voice Result:', transcript);
                processVoiceCommand(transcript);
            };

            recognition.onerror = (event) => {
                console.error('Recognition Error:', event.error);
                stopVoiceSearch();
            };

            recognition.onend = () => {
                stopVoiceSearch();
            };

            recognition.start();
        }

        function stopVoiceSearch() {
            if (recognition) {
                recognition.stop();
            }
            isListening = false;
            const voiceBtn = document.getElementById('voiceBtn');
            voiceBtn.classList.remove('listening');
            console.log('Voice recognition stopped.');
        }

        function processVoiceCommand(transcript) {
            // City mapping based on seeder data
            const cityMap = {
                'karachi': '1',
                'lahore': '2',
                'islamabad': '3',
                'rawalpindi': '4',
                'faisalabad': '5',
                'multan': '6',
                'peshawar': '7',
                'quetta': '8',
                'sialkot': '9',
                'gujranwala': '10'
            };

            // Detect pattern: "from [City] to [City]"
            const fromToPattern = /from\s+(\w+)\s+to\s+(\w+)/i;
            const match = transcript.match(fromToPattern);

            if (match) {
                const fromCity = match[1].toLowerCase();
                const toCity = match[2].toLowerCase();

                if (cityMap[fromCity]) {
                    document.getElementById('fromCity').value = cityMap[fromCity];
                }
                if (cityMap[toCity]) {
                    document.getElementById('toCity').value = cityMap[toCity];
                }

                // Auto-submit after a short delay
                setTimeout(() => {
                    document.querySelector('.search-form').submit();
                }, 1000);
            } else {
                // Individual city detection
                Object.keys(cityMap).forEach(city => {
                    if (transcript.includes(city)) {
                        // If "from" is mentioned but only one city
                        if (transcript.includes('from ' + city)) {
                            document.getElementById('fromCity').value = cityMap[city];
                        } 
                        // If "to" is mentioned
                        else if (transcript.includes('to ' + city)) {
                            document.getElementById('toCity').value = cityMap[city];
                        }
                    }
                });
            }
        }

        // How to Book Section Scroll Animation
        const howToBookSection = document.getElementById('howToBookSection');
        if (howToBookSection) {
            const stepCards = howToBookSection.querySelectorAll('.booking-step-card');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        stepCards.forEach((card, index) => {
                            setTimeout(() => {
                                card.classList.add('animate-in');
                            }, index * 150);
                        });
                        observer.unobserve(entry.target);
                    }
                });
            }, {
                threshold: 0.2,
                rootMargin: '0px 0px -50px 0px'
            });
            
            observer.observe(howToBookSection);
        }
    </script>
</body>
</html>
