

<?php $__env->startSection('title', 'Bookings'); ?>
<?php $__env->startSection('page-title', 'Bookings Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Bookings (<?php echo e($bookings->total()); ?>)</h3>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Route</th>
                    <th>Passenger</th>
                    <th>Driver</th>
                    <th>Seats</th>
                    <th>Price</th>
                    <th>Payment</th>
                    <th>Status</th>
                    <th>Booked On</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div style="font-weight: 700;">
                                <?php echo e($booking->ride->route->fromCity->name ?? 'N/A'); ?> → <?php echo e($booking->ride->route->toCity->name ?? 'N/A'); ?>

                            </div>
                            <div style="font-size: 12px; color: #64748b;">
                                <?php echo e($booking->ride->departure_datetime ? $booking->ride->departure_datetime->format('M d, Y') : 'N/A'); ?>

                            </div>
                        </td>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm"><?php echo e(substr($booking->passenger->name ?? 'P', 0, 1)); ?></div>
                                <div>
                                    <div style="font-weight: 600;"><?php echo e($booking->passenger->name ?? 'N/A'); ?></div>
                                    <div style="font-size: 12px; color: #64748b;"><?php echo e($booking->passenger->phone ?? ''); ?></div>
                                </div>
                            </div>
                        </td>
                        <td><?php echo e($booking->ride->driver->name ?? 'N/A'); ?></td>
                        <td style="font-weight: 700;"><?php echo e($booking->number_of_seats); ?></td>
                        <td style="font-weight: 700; color: #10b981;">Rs <?php echo e(number_format($booking->total_price * 280)); ?></td>
                        <td>
                            <?php if($booking->payment_status == 'paid'): ?>
                                <span class="badge badge-success">Paid</span>
                            <?php elseif($booking->payment_status == 'pending'): ?>
                                <span class="badge badge-warning">Pending</span>
                            <?php else: ?>
                                <span class="badge badge-danger"><?php echo e(ucfirst($booking->payment_status)); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($booking->booking_status == 'confirmed'): ?>
                                <span class="badge badge-success">Confirmed</span>
                            <?php elseif($booking->booking_status == 'completed'): ?>
                                <span class="badge badge-info">Completed</span>
                            <?php elseif($booking->booking_status == 'cancelled'): ?>
                                <span class="badge badge-danger">Cancelled</span>
                            <?php else: ?>
                                <span class="badge badge-warning"><?php echo e(ucfirst($booking->booking_status)); ?></span>
                            <?php endif; ?>
                        </td>
                        <td style="font-size: 13px; color: #64748b;"><?php echo e($booking->created_at->format('M d, Y')); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" style="text-align: center; color: #64748b; padding: 40px;">No bookings found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        <?php echo e($bookings->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/admin/bookings.blade.php ENDPATH**/ ?>