

<?php $__env->startSection('title', 'Payments'); ?>
<?php $__env->startSection('page-title', 'Payments Management'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Payment Stats -->
    <div class="stats-grid" style="margin-bottom: 24px;">
        <div class="stat-card">
            <div class="stat-icon green">💰</div>
            <div class="stat-value">Rs <?php echo e(number_format($stats['total_revenue'])); ?></div>
            <div class="stat-label">Total Revenue</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon blue">✅</div>
            <div class="stat-value"><?php echo e($stats['paid_bookings']); ?></div>
            <div class="stat-label">Paid Bookings</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon orange">⏳</div>
            <div class="stat-value"><?php echo e($stats['pending_payments']); ?></div>
            <div class="stat-label">Pending Payments</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon purple">📱</div>
            <div class="stat-value"><?php echo e($stats['mobile_payments']); ?></div>
            <div class="stat-label">Mobile Payments</div>
        </div>
    </div>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 24px;">
        <!-- Payment Gateway Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">🔧 Payment Gateway Settings</h3>
            </div>
            <div style="padding: 24px;">
                <form action="<?php echo e(route('admin.payments.update-settings')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <!-- JazzCash -->
                    <div style="background: #fee2e2; border-radius: 12px; padding: 16px; margin-bottom: 16px;">
                        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                            <div style="display: flex; align-items: center; gap: 12px;">
                                <span style="font-size: 28px;">📱</span>
                                <div>
                                    <div style="font-weight: 700; color: #991b1b;">JazzCash</div>
                                    <div style="font-size: 12px; color: #64748b;">Mobile Wallet</div>
                                </div>
                            </div>
                            <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                                <input type="checkbox" name="jazzcash_enabled" value="1" <?php echo e(config('payment.jazzcash_enabled', true) ? 'checked' : ''); ?> style="width: 20px; height: 20px; accent-color: #ef4444;">
                                <span style="font-size: 13px; font-weight: 600;">Active</span>
                            </label>
                        </div>
                        <div style="margin-bottom: 12px;">
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Merchant ID</label>
                            <input type="text" name="jazzcash_merchant_id" value="" placeholder="MC12345" style="width: 100%; padding: 10px 14px; border: 2px solid #fecaca; border-radius: 8px; font-size: 13px;">
                        </div>
                        <div style="margin-bottom: 12px;">
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Password</label>
                            <input type="password" name="jazzcash_password" value="" placeholder="••••••••" style="width: 100%; padding: 10px 14px; border: 2px solid #fecaca; border-radius: 8px; font-size: 13px;">
                        </div>
                        <div>
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Integration Key</label>
                            <input type="text" name="jazzcash_key" value="" placeholder="XXXX-XXXX-XXXX" style="width: 100%; padding: 10px 14px; border: 2px solid #fecaca; border-radius: 8px; font-size: 13px;">
                        </div>
                    </div>

                    <!-- Easypaisa -->
                    <div style="background: #d1fae5; border-radius: 12px; padding: 16px; margin-bottom: 16px;">
                        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                            <div style="display: flex; align-items: center; gap: 12px;">
                                <span style="font-size: 28px;">📲</span>
                                <div>
                                    <div style="font-weight: 700; color: #065f46;">Easypaisa</div>
                                    <div style="font-size: 12px; color: #64748b;">Mobile Wallet</div>
                                </div>
                            </div>
                            <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                                <input type="checkbox" name="easypaisa_enabled" value="1" <?php echo e(config('payment.easypaisa_enabled', true) ? 'checked' : ''); ?> style="width: 20px; height: 20px; accent-color: #10b981;">
                                <span style="font-size: 13px; font-weight: 600;">Active</span>
                            </label>
                        </div>
                        <div style="margin-bottom: 12px;">
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Store ID</label>
                            <input type="text" name="easypaisa_store_id" value="" placeholder="STORE123" style="width: 100%; padding: 10px 14px; border: 2px solid #a7f3d0; border-radius: 8px; font-size: 13px;">
                        </div>
                        <div style="margin-bottom: 12px;">
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Account Number</label>
                            <input type="text" name="easypaisa_account" value="" placeholder="03XXXXXXXXX" style="width: 100%; padding: 10px 14px; border: 2px solid #a7f3d0; border-radius: 8px; font-size: 13px;">
                        </div>
                        <div>
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Hash Key</label>
                            <input type="text" name="easypaisa_hash" value="" placeholder="XXXX-XXXX-XXXX" style="width: 100%; padding: 10px 14px; border: 2px solid #a7f3d0; border-radius: 8px; font-size: 13px;">
                        </div>
                    </div>

                    <!-- Sadapay / NayaPay / Bank -->
                    <div style="background: #e0f7fa; border-radius: 12px; padding: 16px; margin-bottom: 16px;">
                        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                            <div style="display: flex; align-items: center; gap: 12px;">
                                <span style="font-size: 28px;">🏦</span>
                                <div>
                                    <div style="font-weight: 700; color: #0369a1;">Bank Transfer</div>
                                    <div style="font-size: 12px; color: #64748b;">Direct Bank / SadaPay / NayaPay</div>
                                </div>
                            </div>
                            <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                                <input type="checkbox" name="bank_enabled" value="1" checked style="width: 20px; height: 20px; accent-color: #00aff5;">
                                <span style="font-size: 13px; font-weight: 600;">Active</span>
                            </label>
                        </div>
                        <div style="margin-bottom: 12px;">
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Bank Name</label>
                            <input type="text" name="bank_name" value="HBL" placeholder="HBL / MCB / UBL" style="width: 100%; padding: 10px 14px; border: 2px solid #99e6f2; border-radius: 8px; font-size: 13px;">
                        </div>
                        <div style="margin-bottom: 12px;">
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Account Title</label>
                            <input type="text" name="bank_title" value="KKH Ride Pvt Ltd" style="width: 100%; padding: 10px 14px; border: 2px solid #99e6f2; border-radius: 8px; font-size: 13px;">
                        </div>
                        <div>
                            <label style="display: block; font-size: 11px; font-weight: 700; color: #64748b; margin-bottom: 4px;">Account Number / IBAN</label>
                            <input type="text" name="bank_account" value="" placeholder="PK00XXXX0000000000000000" style="width: 100%; padding: 10px 14px; border: 2px solid #99e6f2; border-radius: 8px; font-size: 13px;">
                        </div>
                    </div>

                    <!-- Cash on Ride -->
                    <div style="background: #fef3c7; border-radius: 12px; padding: 16px; margin-bottom: 20px;">
                        <div style="display: flex; align-items: center; justify-content: space-between;">
                            <div style="display: flex; align-items: center; gap: 12px;">
                                <span style="font-size: 28px;">💵</span>
                                <div>
                                    <div style="font-weight: 700; color: #92400e;">Cash on Ride</div>
                                    <div style="font-size: 12px; color: #64748b;">Pay directly to driver</div>
                                </div>
                            </div>
                            <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                                <input type="checkbox" name="cash_enabled" value="1" checked style="width: 20px; height: 20px; accent-color: #f59e0b;">
                                <span style="font-size: 13px; font-weight: 600;">Active</span>
                            </label>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary" style="width: 100%;">💾 Save Payment Settings</button>
                </form>
            </div>
        </div>

        <!-- Pricing Settings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">💲 Pricing & Commission</h3>
            </div>
            <div style="padding: 24px;">
                <form action="<?php echo e(route('admin.payments.update-pricing')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Platform Fee (PKR)</label>
                        <input type="number" name="platform_fee" value="50" style="width: 100%; padding: 14px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                        <div style="font-size: 11px; color: #94a3b8; margin-top: 4px;">Fixed fee added to each booking</div>
                    </div>
                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Driver Commission (%)</label>
                        <input type="number" name="driver_commission" value="10" min="0" max="50" style="width: 100%; padding: 14px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                        <div style="font-size: 11px; color: #94a3b8; margin-top: 4px;">Percentage taken from driver earnings</div>
                    </div>
                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Minimum Ride Price (PKR)</label>
                        <input type="number" name="min_price" value="500" style="width: 100%; padding: 14px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                    <div style="margin-bottom: 20px;">
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Maximum Ride Price (PKR)</label>
                        <input type="number" name="max_price" value="50000" style="width: 100%; padding: 14px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                    <button type="submit" class="btn btn-primary" style="width: 100%;">💾 Save Pricing</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Recent Payments Table -->
    <div class="card" style="margin-top: 24px;">
        <div class="card-header">
            <h3 class="card-title">Recent Payments</h3>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Booking ID</th>
                    <th>Passenger</th>
                    <th>Route</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $recent_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td style="font-weight: 700;">#<?php echo e($booking->id); ?></td>
                        <td><?php echo e($booking->passenger->name ?? 'N/A'); ?></td>
                        <td><?php echo e($booking->ride->route->fromCity->name ?? 'N/A'); ?> → <?php echo e($booking->ride->route->toCity->name ?? 'N/A'); ?></td>
                        <td style="font-weight: 700; color: #10b981;">Rs <?php echo e(number_format($booking->total_price * 280)); ?></td>
                        <td>
                            <?php if(str_contains(strtolower($booking->payment_method ?? 'cash'), 'jazz')): ?>
                                <span class="badge" style="background: #fee2e2; color: #991b1b;">JazzCash</span>
                            <?php elseif(str_contains(strtolower($booking->payment_method ?? ''), 'easy')): ?>
                                <span class="badge" style="background: #d1fae5; color: #065f46;">Easypaisa</span>
                            <?php else: ?>
                                <span class="badge" style="background: #fef3c7; color: #92400e;">Cash</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($booking->payment_status == 'paid'): ?>
                                <span class="badge badge-success">Paid</span>
                            <?php elseif($booking->payment_status == 'pending'): ?>
                                <span class="badge badge-warning">Pending</span>
                            <?php else: ?>
                                <span class="badge badge-danger"><?php echo e(ucfirst($booking->payment_status)); ?></span>
                            <?php endif; ?>
                        </td>
                        <td style="font-size: 13px; color: #64748b;"><?php echo e($booking->created_at->format('M d, Y')); ?></td>
                        <td>
                            <?php if($booking->payment_status == 'pending'): ?>
                                <form action="<?php echo e(route('admin.payments.verify', $booking->id)); ?>" method="POST" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-primary btn-sm">Verify</button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" style="text-align: center; color: #64748b; padding: 40px;">No payments yet</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/admin/payments.blade.php ENDPATH**/ ?>