

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    /* Header */
    .dash-header {
        background: linear-gradient(135deg, #1e3a5f 0%, #0d1b2a 100%);
        border-radius: 20px;
        padding: 20px;
        margin-bottom: 16px;
        color: white;
    }

    .dash-greeting {
        font-size: 12px;
        color: rgba(255,255,255,0.7);
        margin-bottom: 4px;
    }

    .dash-name {
        font-size: 22px;
        font-weight: 800;
        margin-bottom: 8px;
    }

    .dash-subtitle {
        font-size: 12px;
        color: rgba(255,255,255,0.6);
    }

    /* Stats Row */
    .stats-row {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
        margin-bottom: 16px;
    }

    .stat-card {
        background: white;
        border-radius: 14px;
        padding: 16px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.04);
    }

    .stat-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 10px;
    }

    .stat-icon.blue { background: #e0f7fa; }
    .stat-icon.green { background: #d1fae5; }
    .stat-icon.purple { background: #ede9fe; }
    .stat-icon.orange { background: #fef3c7; }

    .stat-icon svg {
        width: 20px;
        height: 20px;
    }

    .stat-icon.blue svg { color: #00aff5; }
    .stat-icon.green svg { color: #10b981; }
    .stat-icon.purple svg { color: #8b5cf6; }
    .stat-icon.orange svg { color: #f59e0b; }

    .stat-value {
        font-size: 22px;
        font-weight: 800;
        color: #1e3a5f;
    }

    .stat-label {
        font-size: 11px;
        color: #64748b;
        font-weight: 600;
    }

    /* Section */
    .section {
        margin-bottom: 16px;
    }

    .section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 12px;
    }

    .section-title {
        font-size: 16px;
        font-weight: 800;
        color: #1e3a5f;
    }

    .section-link {
        font-size: 12px;
        font-weight: 700;
        color: #00aff5;
        text-decoration: none;
    }

    /* Card */
    .card {
        background: white;
        border-radius: 16px;
        padding: 16px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.04);
    }

    /* Upcoming Ride */
    .ride-card {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 12px;
        background: #f8fafc;
        border-radius: 12px;
        margin-bottom: 10px;
    }

    .ride-card:last-child {
        margin-bottom: 0;
    }

    .ride-icon {
        width: 44px;
        height: 44px;
        background: linear-gradient(135deg, #00aff5, #10b981);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .ride-icon svg {
        width: 22px;
        height: 22px;
        color: white;
    }

    .ride-info {
        flex: 1;
        min-width: 0;
    }

    .ride-route {
        font-size: 13px;
        font-weight: 700;
        color: #1e3a5f;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .ride-meta {
        font-size: 11px;
        color: #64748b;
    }

    .ride-status {
        padding: 4px 10px;
        border-radius: 20px;
        font-size: 10px;
        font-weight: 700;
        white-space: nowrap;
    }

    .status-confirmed {
        background: #d1fae5;
        color: #065f46;
    }

    .status-pending {
        background: #fef3c7;
        color: #92400e;
    }

    /* Quick Actions */
    .quick-actions {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
    }

    .action-btn {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 8px;
        padding: 16px;
        background: white;
        border-radius: 14px;
        text-decoration: none;
        box-shadow: 0 2px 10px rgba(0,0,0,0.04);
    }

    .action-icon {
        width: 44px;
        height: 44px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .action-icon svg {
        width: 22px;
        height: 22px;
        color: white;
    }

    .action-icon.blue { background: linear-gradient(135deg, #00aff5, #0ea5e9); }
    .action-icon.green { background: linear-gradient(135deg, #10b981, #059669); }
    .action-icon.purple { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
    .action-icon.orange { background: linear-gradient(135deg, #f59e0b, #d97706); }

    .action-text {
        font-size: 12px;
        font-weight: 700;
        color: #1e3a5f;
        text-align: center;
    }

    /* History */
    .history-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 12px 0;
        border-bottom: 1px solid #f1f5f9;
    }

    .history-item:last-child {
        border-bottom: none;
        padding-bottom: 0;
    }

    .history-date {
        text-align: center;
        min-width: 40px;
    }

    .history-day {
        font-size: 18px;
        font-weight: 800;
        color: #1e3a5f;
    }

    .history-month {
        font-size: 10px;
        color: #64748b;
        font-weight: 600;
        text-transform: uppercase;
    }

    .history-info {
        flex: 1;
        min-width: 0;
    }

    .history-route {
        font-size: 13px;
        font-weight: 700;
        color: #1e3a5f;
    }

    .history-meta {
        font-size: 11px;
        color: #64748b;
    }

    .history-price {
        font-size: 13px;
        font-weight: 800;
        color: #10b981;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 30px 20px;
    }

    .empty-icon {
        font-size: 40px;
        margin-bottom: 12px;
    }

    .empty-title {
        font-size: 15px;
        font-weight: 700;
        color: #1e3a5f;
        margin-bottom: 6px;
    }

    .empty-text {
        font-size: 12px;
        color: #64748b;
        margin-bottom: 16px;
    }

    .empty-btn {
        display: inline-block;
        padding: 12px 24px;
        background: linear-gradient(135deg, #00aff5, #10b981);
        color: white;
        border-radius: 12px;
        font-size: 13px;
        font-weight: 700;
        text-decoration: none;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="dash-header">
        <div class="dash-greeting">Good <?php echo e(date('H') < 12 ? 'morning' : (date('H') < 17 ? 'afternoon' : 'evening')); ?> 👋</div>
        <div class="dash-name"><?php echo e($user->name ?? 'Traveler'); ?></div>
        <div class="dash-subtitle">Your next adventure awaits</div>
    </div>

    <!-- Stats -->
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-icon blue">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                </svg>
            </div>
            <div class="stat-value"><?php echo e($stats['points'] ?? 1250); ?></div>
            <div class="stat-label">Reward Points</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon purple">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <circle cx="12" cy="12" r="10"></circle>
                    <polyline points="12 6 12 12 16 14"></polyline>
                </svg>
            </div>
            <div class="stat-value"><?php echo e($stats['rides'] ?? 0); ?></div>
            <div class="stat-label">Total Rides</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path>
                </svg>
            </div>
            <div class="stat-value"><?php echo e($stats['co2'] ?? 48); ?> kg</div>
            <div class="stat-label">CO₂ Saved</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon orange">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                    <line x1="12" y1="1" x2="12" y2="23"></line>
                    <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                </svg>
            </div>
            <div class="stat-value"><?php echo e(number_format($stats['savings'] ?? 12500)); ?></div>
            <div class="stat-label">Rs Saved</div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="section">
        <div class="section-header">
            <h2 class="section-title">Quick Actions</h2>
        </div>
        <div class="quick-actions">
            <a href="<?php echo e(route('rides.search')); ?>" class="action-btn">
                <div class="action-icon blue">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                        <circle cx="11" cy="11" r="8"></circle>
                        <path d="M21 21l-4.35-4.35"></path>
                    </svg>
                </div>
                <span class="action-text">Find Ride</span>
            </a>
            <a href="<?php echo e(route('rides.create')); ?>" class="action-btn">
                <div class="action-icon green">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                        <circle cx="12" cy="12" r="10"></circle>
                        <line x1="12" y1="8" x2="12" y2="16"></line>
                        <line x1="8" y1="12" x2="16" y2="12"></line>
                    </svg>
                </div>
                <span class="action-text">Offer Ride</span>
            </a>
            <a href="<?php echo e(route('inbox')); ?>" class="action-btn">
                <div class="action-icon purple">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                    </svg>
                </div>
                <span class="action-text">Messages</span>
            </a>
            <a href="<?php echo e(route('profile')); ?>" class="action-btn">
                <div class="action-icon orange">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                    </svg>
                </div>
                <span class="action-text">Profile</span>
            </a>
        </div>
    </div>

    <!-- Upcoming Rides -->
    <div class="section">
        <div class="section-header">
            <h2 class="section-title">Upcoming Rides</h2>
            <a href="<?php echo e(route('rides.search')); ?>" class="section-link">View All →</a>
        </div>
        <div class="card">
            <?php $__empty_1 = true; $__currentLoopData = $upcomingBookings ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="ride-card">
                    <div class="ride-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"></path>
                            <circle cx="7" cy="17" r="2"></circle>
                            <circle cx="17" cy="17" r="2"></circle>
                        </svg>
                    </div>
                    <div class="ride-info">
                        <div class="ride-route"><?php echo e($booking->ride->route->fromCity->name); ?> → <?php echo e($booking->ride->route->toCity->name); ?></div>
                        <div class="ride-meta"><?php echo e($booking->ride->departure_datetime->format('D, d M')); ?> • <?php echo e($booking->number_of_seats); ?> seat(s)</div>
                    </div>
                    <span class="ride-status status-confirmed">Confirmed</span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="empty-state">
                    <div class="empty-icon">🚗</div>
                    <div class="empty-title">No Upcoming Rides</div>
                    <div class="empty-text">Book your next journey today</div>
                    <a href="<?php echo e(route('rides.search')); ?>" class="empty-btn">Find a Ride</a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Travel History -->
    <div class="section">
        <div class="section-header">
            <h2 class="section-title">Travel History</h2>
            <a href="#" class="section-link">View All →</a>
        </div>
        <div class="card">
            <?php $__empty_1 = true; $__currentLoopData = $pastBookings ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="history-item">
                    <div class="history-date">
                        <div class="history-day"><?php echo e($booking->ride->departure_datetime->format('d')); ?></div>
                        <div class="history-month"><?php echo e($booking->ride->departure_datetime->format('M')); ?></div>
                    </div>
                    <div class="history-info">
                        <div class="history-route"><?php echo e($booking->ride->route->fromCity->name); ?> → <?php echo e($booking->ride->route->toCity->name); ?></div>
                        <div class="history-meta"><?php echo e($booking->ride->driver->name); ?></div>
                    </div>
                    <div class="history-price">Rs <?php echo e(number_format($booking->total_price)); ?></div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="history-item">
                    <div class="history-date">
                        <div class="history-day">15</div>
                        <div class="history-month">Dec</div>
                    </div>
                    <div class="history-info">
                        <div class="history-route">Islamabad → Lahore</div>
                        <div class="history-meta">Ahmad Khan</div>
                    </div>
                    <div class="history-price">Rs 2,500</div>
                </div>
                <div class="history-item">
                    <div class="history-date">
                        <div class="history-day">10</div>
                        <div class="history-month">Dec</div>
                    </div>
                    <div class="history-info">
                        <div class="history-route">Karachi → Hyderabad</div>
                        <div class="history-meta">Ali Hassan</div>
                    </div>
                    <div class="history-price">Rs 1,200</div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/dashboard.blade.php ENDPATH**/ ?>