

<?php $__env->startSection('title', 'Rides'); ?>
<?php $__env->startSection('page-title', 'Rides Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Rides (<?php echo e($rides->total()); ?>)</h3>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Route</th>
                    <th>Driver</th>
                    <th>Vehicle</th>
                    <th>Date & Time</th>
                    <th>Price</th>
                    <th>Seats</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $rides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ride): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div style="font-weight: 700;">
                                <?php echo e($ride->route->fromCity->name ?? 'N/A'); ?> → <?php echo e($ride->route->toCity->name ?? 'N/A'); ?>

                            </div>
                            <div style="font-size: 12px; color: #64748b;">
                                Est. <?php echo e($ride->route->estimated_duration ?? 0); ?> min
                            </div>
                        </td>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm"><?php echo e(substr($ride->driver->name ?? 'D', 0, 1)); ?></div>
                                <div>
                                    <div style="font-weight: 600;"><?php echo e($ride->driver->name ?? 'N/A'); ?></div>
                                    <div style="font-size: 12px; color: #64748b;"><?php echo e($ride->driver->phone ?? ''); ?></div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php if($ride->vehicle): ?>
                                <div style="font-weight: 600;"><?php echo e($ride->vehicle->make); ?> <?php echo e($ride->vehicle->model); ?></div>
                                <div style="font-size: 12px; color: #64748b;"><?php echo e($ride->vehicle->license_plate); ?></div>
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($ride->departure_datetime): ?>
                                <div style="font-weight: 600;"><?php echo e($ride->departure_datetime->format('M d, Y')); ?></div>
                                <div style="font-size: 12px; color: #64748b;"><?php echo e($ride->departure_datetime->format('h:i A')); ?></div>
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>
                        <td style="font-weight: 700; color: #10b981;">Rs <?php echo e(number_format($ride->price_per_seat * 280)); ?></td>
                        <td>
                            <span class="badge badge-<?php echo e($ride->available_seats > 0 ? 'success' : 'danger'); ?>">
                                <?php echo e($ride->available_seats); ?>/<?php echo e($ride->total_seats); ?>

                            </span>
                        </td>
                        <td>
                            <?php if($ride->ride_status == 'scheduled'): ?>
                                <span class="badge badge-success">Scheduled</span>
                            <?php elseif($ride->ride_status == 'completed'): ?>
                                <span class="badge badge-info">Completed</span>
                            <?php else: ?>
                                <span class="badge badge-warning"><?php echo e(ucfirst($ride->ride_status)); ?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" style="text-align: center; color: #64748b; padding: 40px;">No rides found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        <?php echo e($rides->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/admin/rides.blade.php ENDPATH**/ ?>